/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings;

import java.util.List;
import org.eclipse.lemminx.settings.QuoteStyle;
import org.eclipse.lemminx.settings.SchemaDocumentationType;

public class XMLPreferences {
    public static final QuoteStyle DEFAULT_QUOTE_STYLE = QuoteStyle.doubleQuotes;
    public static final SchemaDocumentationType DEFAULT_SCHEMA_DOCUMENTATION_TYPE = SchemaDocumentationType.all;
    private QuoteStyle quoteStyle = DEFAULT_QUOTE_STYLE;
    private SchemaDocumentationType showSchemaDocumentationType = DEFAULT_SCHEMA_DOCUMENTATION_TYPE;
    private List<String> preserveSpace;

    public char getQuotationAsChar() {
        QuoteStyle style = this.getQuoteStyle();
        return QuoteStyle.doubleQuotes.equals((Object)style) ? (char)'\"' : '\'';
    }

    public String getQuotationAsString() {
        return Character.toString(this.getQuotationAsChar());
    }

    public void setQuoteStyle(QuoteStyle quoteStyle) {
        this.quoteStyle = quoteStyle;
    }

    public QuoteStyle getQuoteStyle() {
        return this.quoteStyle;
    }

    public SchemaDocumentationType getShowSchemaDocumentationType() {
        return this.showSchemaDocumentationType;
    }

    public void setShowSchemaDocumentationType(SchemaDocumentationType showSchemaDocumentationType) {
        this.showSchemaDocumentationType = showSchemaDocumentationType;
    }

    public void merge(XMLPreferences newPreferences) {
        this.setQuoteStyle(newPreferences.getQuoteStyle());
        this.setShowSchemaDocumentationType(newPreferences.getShowSchemaDocumentationType());
    }
}

