/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.core.stateprovider;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.linuxtools.internal.lttng2.kernel.core.stateprovider.CtfKernelHandler;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTrace;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateChangeInput;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemBuilder;

public class CtfKernelStateInput
implements IStateChangeInput {
    private static final int EVENTS_QUEUE_SIZE = 10000;
    private final BlockingQueue<CtfTmfEvent> eventsQueue = new ArrayBlockingQueue<CtfTmfEvent>(10000);
    private final CtfTmfTrace trace;
    private final CtfKernelHandler eventHandler;
    private final Thread eventHandlerThread;
    private boolean ssAssigned;

    public CtfKernelStateInput(CtfTmfTrace trace) {
        this.trace = trace;
        this.eventHandler = new CtfKernelHandler(this.eventsQueue);
        this.ssAssigned = false;
        this.eventHandlerThread = new Thread((Runnable)this.eventHandler, "CTF Kernel Event Handler");
    }

    public CtfTmfTrace getTrace() {
        return this.trace;
    }

    public long getStartTime() {
        return this.trace.getStartTime().getValue();
    }

    public CtfTmfEvent getExpectedEventType() {
        return CtfTmfEvent.getNullEvent();
    }

    public void assignTargetStateSystem(IStateSystemBuilder ssb) {
        this.eventHandler.assignStateSystem(ssb);
        this.ssAssigned = true;
        this.eventHandlerThread.start();
    }

    public void processEvent(ITmfEvent event) {
        if (!this.ssAssigned) {
            System.err.println("Cannot process event without a target state system");
            return;
        }
        CtfTmfEvent currentEvent = (CtfTmfEvent)event;
        try {
            this.eventsQueue.put(currentEvent);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        try {
            this.eventsQueue.put(CtfTmfEvent.getNullEvent());
            this.eventHandlerThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.ssAssigned = false;
        this.eventHandler.assignStateSystem(null);
    }
}

