/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.dialogs;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.TargetResource;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.service.ILttControllerService;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.service.LttControllerServiceProxy;
import org.eclipse.linuxtools.internal.lttng.ui.Activator;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.subsystems.TraceSubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.util.TCFTask;

public class ConfigureMarkersDialog
extends Dialog {
    private String[] fMarkersList;
    private TargetResource fTarget;
    private Boolean fOkClicked = false;
    Map<String, Boolean> fMap;
    private TableItem[] fTableLines;
    private Boolean[] fInitialMarkersStates;
    private TraceSubSystem fSubSystem;

    public ConfigureMarkersDialog(Shell parent, TraceSubSystem subSystem) {
        super(parent);
        this.fSubSystem = subSystem;
    }

    public ConfigureMarkersDialog(Shell parent, int style, TraceSubSystem subSystem) {
        super(parent, style);
        this.fSubSystem = subSystem;
    }

    public Map<String, Boolean> open(TargetResource aTarget) {
        this.fTarget = aTarget;
        Shell parent = this.getParent();
        final Display display = parent.getDisplay();
        final Shell shell = new Shell(parent, 67632);
        shell.setText(Messages.ConfigureMarkersDialog_Title);
        shell.setImage(Activator.getDefault().getImage("ICON_ID_CONFIG_MARKERS"));
        shell.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new GridLayout());
        try {
            LttControllerServiceProxy service = this.fSubSystem.getControllerService();
            this.fMarkersList = (String[])new TCFTask<String[]>((ILttControllerService)service){
                private final /* synthetic */ ILttControllerService val$service;
                {
                    this.val$service = iLttControllerService;
                }

                public void run() {
                    this.val$service.getMarkers(ConfigureMarkersDialog.this.fTarget.getParent().getName(), ConfigureMarkersDialog.this.fTarget.getName(), new ILttControllerService.DoneGetMarkers(){

                        public void doneGetMarkers(IToken token, Exception error, String[] str) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            this.done(str);
                        }
                    });
                }
            }.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            SystemMessageException sysExp = e instanceof SystemMessageException ? (SystemMessageException)((Object)e) : new SystemMessageException(Activator.getDefault().getMessage(e));
            SystemBasePlugin.logError((String)(String.valueOf(Messages.Lttng_Control_ErrorGetMarkers) + " (" + Messages.Lttng_Resource_Target + ": " + this.fTarget.getName() + ")"), (Throwable)sysExp);
            return null;
        }
        int i = 0;
        while (i < this.fMarkersList.length) {
            this.fMarkersList[i] = this.fMarkersList[i].trim();
            ++i;
        }
        Table table = new Table(composite, 2080);
        TableColumn tc0 = new TableColumn(table, 0x1004000);
        TableColumn tc1 = new TableColumn(table, 16384);
        TableColumn tc2 = new TableColumn(table, 16384);
        TableColumn tc3 = new TableColumn(table, 16384);
        TableColumn tc4 = new TableColumn(table, 16384);
        TableColumn tc5 = new TableColumn(table, 16384);
        TableColumn tc6 = new TableColumn(table, 16384);
        tc1.setText(Messages.ConfigureMarkersDialog_NameColumn);
        tc2.setText(Messages.ConfigureMarkersDialog_Location);
        tc3.setText(Messages.ConfigureMarkersDialog_Format);
        tc4.setText(Messages.ConfigureMarkersDialog_EventId);
        tc5.setText(Messages.ConfigureMarkersDialog_Call);
        tc6.setText(Messages.ConfigureMarkersDialog_Probe_Single);
        tc0.setWidth(25);
        tc1.setWidth(100);
        tc2.setWidth(100);
        tc3.setWidth(170);
        tc4.pack();
        tc5.setWidth(100);
        tc6.setWidth(100);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTableLines = new TableItem[this.fMarkersList.length];
        this.fInitialMarkersStates = new Boolean[this.fMarkersList.length];
        int i2 = 0;
        while (i2 < this.fMarkersList.length) {
            this.fTableLines[i2] = new TableItem(table, 0);
            String markerInfoResult = null;
            String currentMarker = this.fMarkersList[i2];
            try {
                LttControllerServiceProxy service = this.fSubSystem.getControllerService();
                markerInfoResult = (String)new TCFTask<String>((ILttControllerService)service, currentMarker){
                    private final /* synthetic */ ILttControllerService val$service;
                    private final /* synthetic */ String val$currentMarker;
                    {
                        this.val$service = iLttControllerService;
                        this.val$currentMarker = string;
                    }

                    public void run() {
                        this.val$service.getMarkerInfo(ConfigureMarkersDialog.this.fTarget.getParent().getName(), ConfigureMarkersDialog.this.fTarget.getName(), this.val$currentMarker, new ILttControllerService.DoneGetMarkerInfo(){

                            public void doneGetMarkerInfo(IToken token, Exception error, String str) {
                                if (error != null) {
                                    this.error(error);
                                    return;
                                }
                                this.done(str);
                            }
                        });
                    }
                }.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                SystemMessageException sysExp = e instanceof SystemMessageException ? (SystemMessageException)((Object)e) : new SystemMessageException(Activator.getDefault().getMessage(e));
                SystemBasePlugin.logError((String)(String.valueOf(Messages.Lttng_Control_ErrorGetMarkerInfo) + " (" + Messages.Lttng_Resource_Target + ": " + this.fTarget.getName() + ", " + Messages.Lttng_Resource_Marker + ": " + currentMarker + ")"), (Throwable)sysExp);
                return null;
            }
            String markerInfos = markerInfoResult.substring(1, markerInfoResult.length() - 1);
            int nbOfEqualsHack = 0;
            int x = 0;
            while (x < markerInfos.length()) {
                if (markerInfos.charAt(x) == '=') {
                    ++nbOfEqualsHack;
                }
                ++x;
            }
            if (nbOfEqualsHack > 0) {
                String[] infosList = new String[nbOfEqualsHack];
                String value = "";
                int prevPos = 0;
                int curPos = 0;
                int eqPos = 0;
                int nbDone = 0;
                while (curPos < markerInfos.length() && eqPos >= 0) {
                    eqPos = markerInfos.indexOf("=", curPos);
                    prevPos = eqPos >= 0 ? markerInfos.lastIndexOf(",", eqPos) : markerInfos.length() - 1;
                    if (prevPos >= 0) {
                        infosList[nbDone] = value = markerInfos.substring(curPos, prevPos);
                        ++nbDone;
                    }
                    curPos = eqPos + 1;
                }
                String[] stringArray = new String[7];
                stringArray[1] = this.fMarkersList[i2];
                stringArray[2] = infosList[3];
                stringArray[3] = infosList[4];
                stringArray[4] = infosList[2];
                stringArray[5] = infosList[0];
                stringArray[6] = infosList[5];
                this.fTableLines[i2].setText(stringArray);
                if (infosList[1].compareTo("1") == 0) {
                    this.fTableLines[i2].setChecked(true);
                    this.fInitialMarkersStates[i2] = true;
                } else {
                    this.fTableLines[i2].setForeground(display.getSystemColor(16));
                    this.fInitialMarkersStates[i2] = false;
                }
            }
            ++i2;
        }
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TableItem ti = (TableItem)event.item;
                    if (!ti.getChecked()) {
                        ti.setForeground(display.getSystemColor(16));
                    } else {
                        ti.setForeground(display.getSystemColor(2));
                    }
                }
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gl = new GridLayout(4, false);
        gl.verticalSpacing = 10;
        buttonComposite.setLayout((Layout)gl);
        Label shadow_sep_h = new Label(buttonComposite, 266);
        GridData gd = new GridData(4, 0x1000000, true, false, 4, 1);
        shadow_sep_h.setLayoutData((Object)gd);
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(Messages.ConfigureMarkersDialog_Select_All);
        gd = new GridData(0x1000000, 0x1000000, false, false);
        gd.widthHint = 100;
        selectAllButton.setLayoutData((Object)gd);
        selectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int i = 0;
                while (i < ConfigureMarkersDialog.this.fTableLines.length) {
                    ConfigureMarkersDialog.this.fTableLines[i].setChecked(true);
                    ConfigureMarkersDialog.this.fTableLines[i].setForeground(display.getSystemColor(2));
                    ++i;
                }
            }
        });
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(Messages.ConfigureMarkersDialog_Deselect_All);
        gd = new GridData(0x1000000, 0x1000000, false, false);
        gd.widthHint = 100;
        deselectAllButton.setLayoutData((Object)gd);
        deselectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int i = 0;
                while (i < ConfigureMarkersDialog.this.fTableLines.length) {
                    ConfigureMarkersDialog.this.fTableLines[i].setChecked(false);
                    ConfigureMarkersDialog.this.fTableLines[i].setForeground(display.getSystemColor(16));
                    ++i;
                }
            }
        });
        Button cancelButton = new Button(buttonComposite, 8);
        cancelButton.setText(Messages.ConfigureMarkersDialog_Cancel);
        gd = new GridData();
        gd = new GridData(131072, 0x1000000, true, false);
        gd.widthHint = 100;
        cancelButton.setLayoutData((Object)gd);
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ConfigureMarkersDialog.this.fOkClicked = false;
                shell.dispose();
            }
        });
        Button okButton = new Button(buttonComposite, 8);
        okButton.setText(Messages.ConfigureMarkersDialog_Ok);
        gd = new GridData(0x1000000, 0x1000000, false, false);
        gd.widthHint = 100;
        okButton.setLayoutData((Object)gd);
        okButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ConfigureMarkersDialog.this.fOkClicked = true;
                ConfigureMarkersDialog.this.fMap = new HashMap<String, Boolean>();
                int k = 0;
                while (k < ConfigureMarkersDialog.this.fTableLines.length) {
                    Boolean isChecked = ConfigureMarkersDialog.this.fTableLines[k].getChecked();
                    if (isChecked.booleanValue() != ConfigureMarkersDialog.this.fInitialMarkersStates[k].booleanValue()) {
                        if (isChecked.booleanValue()) {
                            ConfigureMarkersDialog.this.fMap.put(ConfigureMarkersDialog.this.fMarkersList[k], true);
                        } else {
                            ConfigureMarkersDialog.this.fMap.put(ConfigureMarkersDialog.this.fMarkersList[k], false);
                        }
                    }
                    ++k;
                }
                shell.dispose();
            }
        });
        shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    event.doit = false;
                }
            }
        });
        TableItem[] items = table.getItems();
        int i3 = 0;
        while (i3 < items.length) {
            if (i3 % 2 != 0) {
                items[i3].setBackground(Display.getDefault().getSystemColor(34));
            }
            ++i3;
        }
        Point minSize = composite.computeSize(-1, -1);
        shell.setMinimumSize(shell.computeSize((int)minSize.x, (int)minSize.y).x, 200);
        shell.setSize(shell.computeSize(composite.computeSize((int)-1, (int)-1).x, 300));
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!this.fOkClicked.booleanValue()) {
            return null;
        }
        return this.fMap;
    }
}

