/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.systemtap.ui.dashboard.actions.RunModuleAction;
import org.eclipse.linuxtools.systemtap.ui.dashboard.actions.StopModuleAction;
import org.eclipse.linuxtools.systemtap.ui.dashboard.actions.hidden.GetSelectedModule;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.ActiveModuleData;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardModule;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardModuleBrowserView;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IActionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class PauseModuleAction
extends Action
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    private final IActionListener runListener = new IActionListener(){

        public void handleActionEvent() {
            PauseModuleAction.this.setEnablement(true);
        }
    };
    private final IActionListener stopListener = new IActionListener(){

        public void handleActionEvent() {
            PauseModuleAction.this.setEnablement(false);
        }
    };
    private final ISelectionChangedListener activeModuleListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent e) {
            try {
                TreeNode node = (TreeNode)((StructuredSelection)e.getSelection()).getFirstElement();
                if (((ActiveModuleData)node.getData()).paused) {
                    PauseModuleAction.this.setEnablement(false);
                } else {
                    PauseModuleAction.this.setEnablement(true);
                }
            }
            catch (Exception exception) {}
        }
    };
    private final ISelectionChangedListener moduleListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent e) {
            try {
                TreeNode node = (TreeNode)((StructuredSelection)e.getSelection()).getFirstElement();
                IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
                ActiveModuleBrowserView amdv = (ActiveModuleBrowserView)ivp;
                int childcount = node.getChildCount();
                if (childcount == 0 && amdv.isActive((DashboardModule)node.getData()) && !amdv.isPaused((DashboardModule)node.getData())) {
                    PauseModuleAction.this.setEnablement(true);
                } else if (childcount > 0) {
                    boolean pause = false;
                    int j = 0;
                    while (j < childcount) {
                        if (amdv.isActive((DashboardModule)node.getChildAt(j).getData()) && !amdv.isPaused((DashboardModule)node.getChildAt(j).getData())) {
                            pause = true;
                            break;
                        }
                        ++j;
                    }
                    if (pause) {
                        PauseModuleAction.this.setEnablement(true);
                    }
                } else {
                    PauseModuleAction.this.setEnablement(false);
                }
            }
            catch (Exception exception) {}
        }
    };
    private IViewPart view;
    private IAction act;
    private static ArrayList listeners = new ArrayList();

    public void init(IViewPart view) {
        this.view = view;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction act) {
        this.run();
    }

    public void run() {
        DashboardModule module = GetSelectedModule.getModule(this.view);
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
        ActiveModuleBrowserView ambv = (ActiveModuleBrowserView)ivp;
        if (ambv.isActive(module)) {
            ActiveModuleData amd = ambv.pause(module);
            if (amd.cmd.isRunning()) {
                amd.cmd.stop();
                amd.cmd.dispose();
            }
            amd.paused = true;
        }
        PauseModuleAction.fireActionEvent();
        this.setEnablement(false);
        this.buildEnablementChecks();
    }

    public void selectionChanged(IAction act, ISelection select) {
        this.act = act;
        this.setEnablement(false);
        this.buildEnablementChecks();
    }

    private void buildEnablementChecks() {
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardModuleBrowserView");
        if (ivp != null) {
            DashboardModuleBrowserView dmbv = (DashboardModuleBrowserView)ivp;
            dmbv.getViewer().addSelectionChangedListener(this.moduleListener);
            ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
            ActiveModuleBrowserView ambv = (ActiveModuleBrowserView)ivp;
            ambv.getViewer().addSelectionChangedListener(this.activeModuleListener);
            RunModuleAction.addActionListener(this.runListener);
            StopModuleAction.addActionListener(this.stopListener);
        }
    }

    private void setEnablement(boolean enabled) {
        this.act.setEnabled(enabled);
    }

    public void dispose() {
        try {
            IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardModuleBrowserView");
            DashboardModuleBrowserView dmbv = (DashboardModuleBrowserView)ivp;
            dmbv.getViewer().removeSelectionChangedListener(this.moduleListener);
            ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
            ActiveModuleBrowserView ambv = (ActiveModuleBrowserView)ivp;
            ambv.getViewer().removeSelectionChangedListener(this.activeModuleListener);
            RunModuleAction.removeActionListener(this.runListener);
            StopModuleAction.removeActionListener(this.stopListener);
        }
        catch (Exception exception) {}
        this.view = null;
        this.act = null;
    }

    public static void addActionListener(IActionListener listener) {
        listeners.add(listener);
    }

    public static void removeActionListener(IActionListener listener) {
        listeners.remove(listener);
    }

    private static void fireActionEvent() {
        int i = 0;
        while (i < listeners.size()) {
            ((IActionListener)listeners.get(i)).handleActionEvent();
            ++i;
        }
    }
}

