/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class BreakpointWorkingSetCache {
    HashMap<IMarker, Vector<Object>> fCache = new HashMap(15);

    public void addEntry(IMarker marker, Object entry) {
        Vector<Object> list = this.fCache.get(marker);
        if (list == null) {
            list = new Vector();
            list.addElement(entry);
            this.fCache.put(marker, list);
        } else if (!list.contains(entry)) {
            list.addElement(entry);
        }
    }

    public void removeMappedEntry(IMarker marker, Object entry) {
        Vector<Object> list = this.fCache.get(marker);
        if (list != null) {
            list.remove(entry);
        }
    }

    public void flushMarkerCache(IMarker marker) {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        Vector<Object> list = this.fCache.get(marker);
        if (list != null) {
            Object names = "<;#>";
            Object ids = "<;#>";
            int i = 0;
            while (i < list.size()) {
                String name = (String)list.elementAt(i);
                IWorkingSet ws = manager.getWorkingSet(name);
                if (ws != null) {
                    names = (String)names + name + "<;#>";
                    ids = (String)ids + ws.getId() + "<;#>";
                }
                ++i;
            }
            try {
                marker.setAttribute("workingset_name", names);
                marker.setAttribute("workingset_id", ids);
            }
            catch (CoreException e) {
                Object[] errorInfo = new Object[]{names, ids, marker};
                String errorMessage = NLS.bind((String)"Failed to set working set names {0} and ids {1} on marker {2}", (Object[])errorInfo);
                DebugPlugin.logMessage((String)errorMessage, (Throwable)e);
            }
        }
    }
}

