/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.model;

import org.eclipse.swt.graphics.Point;

public final class TextRange {
    public final int colStart;
    public final int colEnd;
    public final int rowStart;
    public final int rowEnd;
    public final String text;
    public static final TextRange EMPTY = new TextRange(0, 0, 0, 0, "");

    public TextRange(int rowStart, int rowEnd, int colStart, int colEnd, String text) {
        this.colStart = colStart;
        this.colEnd = colEnd;
        this.rowStart = rowStart;
        this.rowEnd = rowEnd;
        this.text = text;
    }

    public boolean contains(int col, int row) {
        int colEndInRow;
        int colStartInrow = row == this.rowStart ? this.colStart : 0;
        int n = colEndInRow = row == this.rowEnd - 1 ? this.colEnd : col + 1;
        return col >= colStartInrow && col < colEndInRow && row >= this.rowStart && row < this.rowEnd;
    }

    public boolean contains(int line) {
        return line >= this.rowStart && line < this.rowEnd;
    }

    public boolean isEmpty() {
        return this.colEnd <= this.colStart && this.rowEnd <= this.rowStart;
    }

    public Point getStart() {
        return new Point(this.colStart, this.rowStart);
    }

    public Point getEnd() {
        return new Point(this.colEnd, this.rowEnd);
    }

    public int getColStart() {
        return this.colStart;
    }

    public int getColEnd() {
        return this.colEnd;
    }

    public int getRowStart() {
        return this.rowStart;
    }

    public int getRowEnd() {
        return this.rowEnd;
    }

    public String toString() {
        return String.format("TextRange (%s,%s)-(%s,%s)-'%s'", this.colStart, this.rowStart, this.colEnd, this.rowEnd, this.text);
    }
}

