/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.renderer.text;

import java.io.IOException;
import java.util.LinkedList;
import org.commonmark.renderer.text.LineBreakRendering;

public class TextContentWriter {
    private final Appendable buffer;
    private final LineBreakRendering lineBreakRendering;
    private final LinkedList<String> prefixes = new LinkedList();
    private final LinkedList<Boolean> tight = new LinkedList();
    private String blockSeparator = null;
    private char lastChar;

    public TextContentWriter(Appendable out) {
        this(out, LineBreakRendering.COMPACT);
    }

    public TextContentWriter(Appendable out, LineBreakRendering lineBreakRendering) {
        this.buffer = out;
        this.lineBreakRendering = lineBreakRendering;
    }

    public void whitespace() {
        if (this.lastChar != '\u0000' && this.lastChar != ' ') {
            this.write(' ');
        }
    }

    public void colon() {
        if (this.lastChar != '\u0000' && this.lastChar != ':') {
            this.write(':');
        }
    }

    public void line() {
        this.append('\n');
        this.writePrefixes();
    }

    public void block() {
        this.blockSeparator = this.lineBreakRendering == LineBreakRendering.STRIP ? " " : (this.lineBreakRendering == LineBreakRendering.COMPACT || this.isTight() ? "\n" : "\n\n");
    }

    public void resetBlock() {
        this.blockSeparator = null;
    }

    public void writeStripped(String s) {
        this.write(s.replaceAll("[\\r\\n\\s]+", " "));
    }

    public void write(String s) {
        this.flushBlockSeparator();
        this.append(s);
    }

    public void write(char c) {
        this.flushBlockSeparator();
        this.append(c);
    }

    public void pushPrefix(String prefix) {
        this.prefixes.addLast(prefix);
    }

    public void writePrefix(String prefix) {
        this.write(prefix);
    }

    public void popPrefix() {
        this.prefixes.removeLast();
    }

    public void pushTight(boolean tight) {
        this.tight.addLast(tight);
    }

    public void popTight() {
        this.tight.removeLast();
    }

    private boolean isTight() {
        return !this.tight.isEmpty() && this.tight.getLast() != false;
    }

    private void writePrefixes() {
        for (String prefix : this.prefixes) {
            this.append(prefix);
        }
    }

    private void flushBlockSeparator() {
        if (this.blockSeparator != null) {
            if (this.blockSeparator.equals("\n") || this.blockSeparator.equals("\n\n")) {
                for (int i = 0; i < this.blockSeparator.length(); ++i) {
                    char sep = this.blockSeparator.charAt(i);
                    this.append(sep);
                    this.writePrefixes();
                }
            } else {
                this.append(this.blockSeparator);
            }
            this.blockSeparator = null;
        }
    }

    private void append(String s) {
        try {
            this.buffer.append(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int length = s.length();
        if (length != 0) {
            this.lastChar = s.charAt(length - 1);
        }
    }

    private void append(char c) {
        try {
            this.buffer.append(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.lastChar = c;
    }
}

