/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.ant.internal.ui.editor.formatter.FormattingPreferences;
import org.eclipse.ant.internal.ui.editor.formatter.XmlDocumentFormatter;
import org.eclipse.ant.internal.ui.editor.formatter.XmlDocumentFormattingStrategy;
import org.eclipse.ant.internal.ui.editor.formatter.XmlElementFormattingStrategy;
import org.eclipse.ant.internal.ui.editor.templates.AntContext;
import org.eclipse.ant.internal.ui.editor.text.AntDocumentSetupParticipant;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.IAntModel;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateVariable;

public class XmlFormatter {
    private static final String POS_CATEGORY = "tempAntFormatterCategory";

    public static String format(String text, FormattingPreferences prefs) {
        return XmlFormatter.format(text, prefs, -1);
    }

    private static String format(String text, FormattingPreferences prefs, int indent) {
        Assert.isNotNull((Object)text);
        FormattingPreferences applyPrefs = prefs == null ? new FormattingPreferences() : prefs;
        Document doc = new Document();
        doc.set(text);
        new AntDocumentSetupParticipant().setup((IDocument)doc);
        XmlFormatter.format(applyPrefs, (IDocument)doc, indent);
        return doc.get();
    }

    private static void format(FormattingPreferences prefs, IDocument doc, int indent) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter("org.eclipse.ant.ui.antPartitioning", "__dftl_partition_content_type");
        formatter.setMasterStrategy((IFormattingStrategy)new XmlDocumentFormattingStrategy(prefs, indent));
        formatter.setSlaveStrategy((IFormattingStrategy)new XmlElementFormattingStrategy(prefs), "__xml_tag");
        formatter.format(doc, (IRegion)new Region(0, doc.getLength()));
    }

    public static String format(String text) {
        return XmlFormatter.format(text, null);
    }

    public static void format(TemplateBuffer templateBuffer, AntContext antContext, FormattingPreferences prefs) {
        String templateString = templateBuffer.getString();
        Document fullDocument = new Document(antContext.getDocument().get());
        int completionOffset = antContext.getCompletionOffset();
        try {
            IRegion lineRegion = fullDocument.getLineInformationOfOffset(completionOffset);
            String lineString = fullDocument.get(lineRegion.getOffset(), lineRegion.getLength());
            lineString = XmlFormatter.trimBegin(lineString);
            fullDocument.replace(lineRegion.getOffset(), lineRegion.getLength(), lineString);
        }
        catch (BadLocationException e1) {
            return;
        }
        TemplateVariable[] variables = templateBuffer.getVariables();
        int[] offsets = XmlFormatter.variablesToOffsets(variables, completionOffset);
        Document origTemplateDoc = new Document(fullDocument.get());
        try {
            origTemplateDoc.replace(completionOffset, antContext.getCompletionLength(), templateString);
        }
        catch (BadLocationException e) {
            return;
        }
        Document templateDocument = XmlFormatter.createDocument(origTemplateDoc.get(), XmlFormatter.createPositions(offsets));
        String leadingText = XmlFormatter.getLeadingText((IDocument)fullDocument, antContext.getAntModel(), completionOffset);
        Object newTemplateString = leadingText + templateString;
        int indent = XmlDocumentFormatter.computeIndent(leadingText, prefs.getTabWidth());
        newTemplateString = XmlFormatter.format((String)newTemplateString, prefs, indent);
        try {
            templateDocument.replace(completionOffset, templateString.length(), (String)newTemplateString);
        }
        catch (BadLocationException e) {
            return;
        }
        Position[] positions = null;
        try {
            positions = templateDocument.getPositions(POS_CATEGORY);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
        XmlFormatter.positionsToVariables(positions, variables, completionOffset);
        templateBuffer.setContent((String)newTemplateString, variables);
    }

    private static void positionsToVariables(Position[] positions, TemplateVariable[] variables, int start) {
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            int[] offsets = new int[variable.getOffsets().length];
            int j = 0;
            while (j != offsets.length) {
                offsets[j] = positions[j].getOffset() - start;
                ++j;
            }
            variable.setOffsets(offsets);
            ++i;
        }
    }

    private static Document createDocument(String string, Position[] positions) throws IllegalArgumentException {
        Document doc;
        block5: {
            doc = new Document(string);
            try {
                if (positions == null) break block5;
                doc.addPositionCategory(POS_CATEGORY);
                doc.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater(POS_CATEGORY){

                    protected boolean notDeleted() {
                        if (this.fOffset < this.fPosition.offset && this.fPosition.offset + this.fPosition.length < this.fOffset + this.fLength) {
                            this.fPosition.offset = this.fOffset + this.fLength;
                            return false;
                        }
                        return true;
                    }
                });
                Position[] positionArray = positions;
                int n = positions.length;
                int n2 = 0;
                while (n2 < n) {
                    Position position = positionArray[n2];
                    try {
                        doc.addPosition(POS_CATEGORY, position);
                    }
                    catch (BadLocationException e) {
                        throw new IllegalArgumentException("Position outside of string. offset: " + position.offset + ", length: " + position.length + ", string size: " + string.length(), e);
                    }
                    ++n2;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
        }
        return doc;
    }

    public static String trimBegin(String toBeTrimmed) {
        int i = 0;
        while (i != toBeTrimmed.length() && Character.isWhitespace(toBeTrimmed.charAt(i))) {
            ++i;
        }
        return toBeTrimmed.substring(i);
    }

    private static int[] variablesToOffsets(TemplateVariable[] variables, int start) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i != variables.length) {
            int[] offsets = variables[i].getOffsets();
            int j = 0;
            while (j != offsets.length) {
                list.add(offsets[j]);
                ++j;
            }
            ++i;
        }
        int[] offsets = new int[list.size()];
        int i2 = 0;
        while (i2 != offsets.length) {
            offsets[i2] = (Integer)list.get(i2) + start;
            ++i2;
        }
        Arrays.sort(offsets);
        return offsets;
    }

    private static String getLeadingText(IDocument document, IAntModel model, int completionOffset) {
        AntProjectNode project = model.getProjectNode(false);
        if (project == null) {
            return "";
        }
        AntElementNode node = project.getNode(completionOffset);
        if (node == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(XmlDocumentFormatter.getLeadingWhitespace(node.getOffset(), document));
        buf.append(XmlDocumentFormatter.createIndent());
        return buf.toString();
    }

    private static Position[] createPositions(int[] positions) {
        Position[] p = null;
        if (positions != null) {
            p = new Position[positions.length];
            int i = 0;
            while (i < positions.length) {
                p[i] = new Position(positions[i], 0);
                ++i;
            }
        }
        return p;
    }
}

