/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.design.editparts;

import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.wst.xsd.ui.internal.adt.design.ADTFloatingToolbar;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.ADTFloatingToolbarEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.ColumnEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.CompartmentEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.ComplexTypeEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.FieldEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.RootContentEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.RootHolderEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.StructureEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.TopLevelFieldEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.AbstractModelCollection;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.Compartment;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.FocusTypeColumn;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.RootHolder;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IComplexType;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IField;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IModel;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IStructure;

public class ADTEditPartFactory
implements EditPartFactory {
    public EditPart createEditPart(EditPart context, Object model) {
        EditPart child = this.doCreateEditPart(context, model);
        this.checkChild(child, model);
        return child;
    }

    protected EditPart doCreateEditPart(EditPart context, Object model) {
        BaseEditPart child = null;
        if (model instanceof Compartment) {
            child = new CompartmentEditPart();
        } else if (model instanceof RootHolder) {
            child = new RootHolderEditPart();
        } else if (model instanceof ADTFloatingToolbar.ADTFloatingToolbarModel) {
            child = new ADTFloatingToolbarEditPart(((ADTFloatingToolbar.ADTFloatingToolbarModel)model).getModel());
        } else if (model instanceof AbstractModelCollection) {
            child = new ColumnEditPart();
            if (model instanceof FocusTypeColumn) {
                ColumnEditPart columnEditPart = (ColumnEditPart)child;
                columnEditPart.setSpacing(60);
                columnEditPart.setMinorAlignment(0);
            }
        } else if (model instanceof IComplexType) {
            child = new ComplexTypeEditPart();
        } else if (model instanceof IStructure) {
            child = new StructureEditPart();
        } else if (model instanceof IField) {
            child = context instanceof CompartmentEditPart ? new FieldEditPart() : new TopLevelFieldEditPart();
        } else if (model instanceof IModel) {
            child = new RootContentEditPart();
        }
        return child;
    }

    protected void checkChild(EditPart child, Object model) {
        Assert.isNotNull((Object)child);
        child.setModel(model);
    }
}

