/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.resource.CopyProjectDescriptor;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;

public class CopyProjectRefactoringContribution
extends RefactoringContribution {
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DESTINATION = "destination";
    private static final String ATTRIBUTE_ELEMENT = "element";

    @Override
    public Map<String, String> retrieveArgumentMap(RefactoringDescriptor descriptor) {
        if (descriptor instanceof CopyProjectDescriptor) {
            CopyProjectDescriptor copyDesc = (CopyProjectDescriptor)descriptor;
            HashMap<String, String> map = new HashMap<String, String>();
            IPath resources = copyDesc.getSourcePath();
            String project = copyDesc.getProject();
            map.put(ATTRIBUTE_ELEMENT, ResourceProcessors.resourcePathToHandle(project, resources));
            map.put(ATTRIBUTE_NAME, copyDesc.getNewName());
            IPath destinationPath = copyDesc.getNewLocation();
            map.put(ATTRIBUTE_DESTINATION, ResourceProcessors.resourcePathToHandle(descriptor.getProject(), destinationPath));
            return map;
        }
        return Collections.emptyMap();
    }

    @Override
    public RefactoringDescriptor createDescriptor() {
        return new CopyProjectDescriptor();
    }

    @Override
    public RefactoringDescriptor createDescriptor(String id, String project, String description, String comment, Map<String, String> arguments, int flags) throws IllegalArgumentException {
        String pathString = arguments.get(ATTRIBUTE_ELEMENT);
        String newName = arguments.get(ATTRIBUTE_NAME);
        String destination = arguments.get(ATTRIBUTE_DESTINATION);
        if (destination == null) {
            throw new IllegalArgumentException("Can not restore CopyProjectDescriptor from map, destination missing");
        }
        IPath resourcePath = ResourceProcessors.handleToResourcePath(project, pathString);
        IPath destPath = ResourceProcessors.handleToResourcePath(project, destination);
        if (resourcePath != null && newName != null) {
            CopyProjectDescriptor descriptor = new CopyProjectDescriptor();
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(flags);
            descriptor.setResourcePath(resourcePath);
            descriptor.setNewName(newName);
            descriptor.setNewLocation(destPath);
            descriptor.setResourcePath(resourcePath);
            return descriptor;
        }
        throw new IllegalArgumentException("Can not restore CopyProjectDescriptor from map");
    }
}

