/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.CacheCredentialsAuthenticationStrategy;

public class ChainedCredentialsProvider
implements CredentialsStore {
    private final CredentialsStore first;
    private final CredentialsStore second;

    public ChainedCredentialsProvider(CredentialsStore first, CredentialsStore second) {
        this.first = first;
        this.second = second;
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        this.first.setCredentials(authscope, credentials);
    }

    public Credentials getCredentials(AuthScope authscope, HttpContext context) {
        Credentials credentials = this.first.getCredentials(authscope, context);
        if (credentials != null) {
            return credentials;
        }
        credentials = this.second.getCredentials(authscope, context);
        context.setAttribute(CacheCredentialsAuthenticationStrategy.CURRENT_CREDENTIALS, (Object)credentials);
        return credentials;
    }

    public void clear() {
        this.first.clear();
        this.second.clear();
    }

    public CredentialsStore getFirst() {
        return this.first;
    }

    public CredentialsStore getSecond() {
        return this.second;
    }
}

