/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.CommentEditor;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentModel;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TaskAttachmentPage
extends WizardPage {
    private Button attachContextButton;
    private CommentEditor commentEditor;
    private Text descriptionText;
    private Combo contentTypeList;
    private Text fileNameText;
    private Button isPatchButton;
    private final TaskAttachmentModel model;
    private boolean needsDescription;
    private final TaskAttachmentMapper taskAttachment;
    private boolean first = true;
    private boolean needsReplaceExisting;
    private Button replaceExistingButton;

    public TaskAttachmentPage(TaskAttachmentModel model) {
        super("AttachmentDetails");
        this.model = model;
        this.taskAttachment = TaskAttachmentMapper.createFrom((TaskAttribute)model.getAttribute());
        this.setTitle(Messages.TaskAttachmentPage_Attachment_Details);
        this.setNeedsDescription(true);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        this.setControl((Control)composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(3, false));
        new Label(composite, 0).setText(Messages.TaskAttachmentPage_File);
        this.fileNameText = new Text(composite, 2048);
        this.fileNameText.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        if (this.needsReplaceExisting) {
            new Label(composite, 0);
            this.replaceExistingButton = new Button(composite, 32);
            this.replaceExistingButton.setLayoutData((Object)new GridData(-1, -1, false, false, 2, 1));
            this.replaceExistingButton.setText(Messages.TaskAttachmentPage_Replace_existing_attachment_Label);
            this.replaceExistingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TaskAttachmentPage.this.taskAttachment.setReplaceExisting(Boolean.valueOf(TaskAttachmentPage.this.replaceExistingButton.getSelection()));
                    TaskAttachmentPage.this.validate();
                }
            });
        }
        if (this.needsDescription) {
            new Label(composite, 0).setText(Messages.TaskAttachmentPage_Description);
            this.descriptionText = new Text(composite, 2048);
            this.descriptionText.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
            this.descriptionText.addModifyListener(e -> {
                this.taskAttachment.setDescription(this.descriptionText.getText().trim());
                this.validate();
            });
        }
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        label.setText(Messages.TaskAttachmentPage_Comment);
        this.commentEditor = new CommentEditor(this.getModel().getTask(), this.getModel().getTaskRepository()){

            @Override
            protected void valueChanged(String value) {
                TaskAttachmentPage.this.apply();
            }
        };
        this.commentEditor.createControl(composite);
        new Label(composite, 0).setText(Messages.TaskAttachmentPage_Content_Type);
        this.contentTypeList = new Combo(composite, 2060);
        this.contentTypeList.setLayoutData((Object)new GridData(-1, -1, false, false, 2, 1));
        String[] contentTypes = FileTaskAttachmentSource.getContentTypes();
        int selection = 0;
        int i = 0;
        while (i < contentTypes.length) {
            String next = contentTypes[i];
            this.contentTypeList.add(next);
            if (next.equalsIgnoreCase(this.model.getContentType())) {
                selection = i;
            }
            ++i;
        }
        this.contentTypeList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TaskAttachmentPage.this.taskAttachment.setContentType(TaskAttachmentPage.this.contentTypeList.getItem(TaskAttachmentPage.this.contentTypeList.getSelectionIndex()));
                TaskAttachmentPage.this.validate();
            }
        });
        this.contentTypeList.select(selection);
        this.taskAttachment.setContentType(this.contentTypeList.getItem(selection));
        new Label(composite, 0);
        this.isPatchButton = new Button(composite, 32);
        this.isPatchButton.setLayoutData((Object)new GridData(-1, -1, false, false, 2, 1));
        this.isPatchButton.setText(Messages.TaskAttachmentPage_Patch);
        new Label(composite, 0);
        this.attachContextButton = new Button(composite, 32);
        this.attachContextButton.setLayoutData((Object)new GridData(-1, -1, false, false, 2, 1));
        this.attachContextButton.setText(Messages.TaskAttachmentPage_ATTACHE_CONTEXT);
        this.attachContextButton.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_ATTACH));
        this.attachContextButton.setEnabled(TasksUiPlugin.getContextStore().hasContext(this.model.getTask()));
        this.fileNameText.addModifyListener(e -> {
            this.taskAttachment.setFileName(this.fileNameText.getText());
            this.setContentTypeFromFilename(this.fileNameText.getText());
            this.validate();
        });
        this.isPatchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private int lastSelected;

            public void widgetSelected(SelectionEvent e) {
                TaskAttachmentPage.this.taskAttachment.setPatch(Boolean.valueOf(TaskAttachmentPage.this.isPatchButton.getSelection()));
                if (TaskAttachmentPage.this.isPatchButton.getSelection()) {
                    this.lastSelected = TaskAttachmentPage.this.contentTypeList.getSelectionIndex();
                    TaskAttachmentPage.this.contentTypeList.select(0);
                    TaskAttachmentPage.this.contentTypeList.setEnabled(false);
                    if (TaskAttachmentPage.this.attachContextButton.isEnabled()) {
                        TaskAttachmentPage.this.attachContextButton.setSelection(true);
                    }
                } else {
                    TaskAttachmentPage.this.contentTypeList.setEnabled(true);
                    TaskAttachmentPage.this.contentTypeList.select(this.lastSelected);
                }
                TaskAttachmentPage.this.validate();
            }
        });
        this.attachContextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskAttachmentPage.this.validate();
            }
        });
        this.validate();
        this.setErrorMessage(null);
        if (this.descriptionText != null) {
            this.descriptionText.setFocus();
        } else {
            this.commentEditor.getTextEditor().getControl().setFocus();
        }
        Dialog.applyDialogFont((Control)composite);
    }

    private void validate() {
        this.apply();
        if (this.fileNameText != null && "".equals(this.fileNameText.getText().trim())) {
            this.setMessage(Messages.TaskAttachmentPage_Enter_a_file_name);
            this.setPageComplete(false);
        } else if (this.descriptionText != null && "".equals(this.descriptionText.getText().trim())) {
            this.setMessage(Messages.TaskAttachmentPage_Enter_a_description);
            this.setPageComplete(false);
        } else {
            this.setMessage(Messages.TaskAttachmentPage_Verify_the_content_type_of_the_attachment);
            this.setPageComplete(true);
        }
    }

    public TaskAttachmentModel getModel() {
        return this.model;
    }

    private void apply() {
        this.taskAttachment.applyTo(this.model.getAttribute());
        this.model.setComment(this.commentEditor.getText());
        this.model.setAttachContext(this.attachContextButton.getSelection());
        this.model.setContentType(this.taskAttachment.getContentType());
    }

    private void setContentType(String contentType) {
        String[] typeList = this.contentTypeList.getItems();
        int i = 0;
        while (i < typeList.length) {
            if (typeList[i].equals(contentType)) {
                this.contentTypeList.select(i);
                this.taskAttachment.setContentType(contentType);
                this.validate();
                break;
            }
            ++i;
        }
    }

    private void setContentTypeFromFilename(String fileName) {
        this.setContentType(FileTaskAttachmentSource.getContentTypeFromFilename((String)fileName));
    }

    private void setFilePath(String path) {
        this.fileNameText.setText(path);
        this.taskAttachment.setFileName(path);
        if (path.endsWith(".patch")) {
            this.isPatchButton.setSelection(true);
            this.taskAttachment.setPatch(Boolean.valueOf(true));
            if (this.attachContextButton.isEnabled()) {
                this.attachContextButton.setSelection(true);
            }
        }
        this.validate();
    }

    public void setNeedsDescription(boolean supportsDescription) {
        this.needsDescription = supportsDescription;
    }

    @Deprecated
    public boolean supportsDescription() {
        return this.needsDescription();
    }

    public boolean needsDescription() {
        return this.needsDescription;
    }

    public void setVisible(boolean visible) {
        if (visible && !this.fileNameText.getText().equals(this.taskAttachment.getFileName())) {
            this.fileNameText.setText(this.taskAttachment.getFileName() == null ? "" : this.taskAttachment.getFileName());
            if (this.fileNameText.getText().length() == 0) {
                this.setFilePath(this.getModel().getSource().getName());
                this.setContentType(this.getModel().getSource().getContentType());
            }
        }
        super.setVisible(visible);
        if (this.first) {
            if (this.descriptionText != null) {
                this.descriptionText.setFocus();
            } else {
                this.commentEditor.getTextEditor().getControl().setFocus();
            }
            this.first = false;
        }
    }

    public void dispose() {
        super.dispose();
        this.commentEditor.dispose();
    }

    public void setNeedsReplaceExisting(boolean needsReplaceExisting) {
        this.needsReplaceExisting = needsReplaceExisting;
    }

    public boolean needsReplaceExisting() {
        return this.needsReplaceExisting;
    }
}

