/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDINullValue;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.BinaryOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;

public class PlusOperator
extends BinaryOperator {
    public static final String NULL = "null";
    public static final String TOSTRING_SELECTOR = "toString";
    public static final String TOSTRING_SIGNATURE = "()Ljava/lang/String;";

    public PlusOperator(int resultId, int leftTypeId, int rightTypeId, int start) {
        this(resultId, leftTypeId, rightTypeId, false, start);
    }

    protected PlusOperator(int resultId, int leftTypeId, int rightTypeId, boolean isAssignmentOperator, int start) {
        super(resultId, leftTypeId, rightTypeId, isAssignmentOperator, start);
    }

    private String getString(IJavaValue value, int typeId) throws DebugException {
        if (value instanceof JDINullValue) {
            return NULL;
        }
        if (value instanceof IJavaObject) {
            if (typeId == 11) {
                return value.getValueString();
            }
            return ((IJavaObject)value).sendMessage(TOSTRING_SELECTOR, TOSTRING_SIGNATURE, null, this.getContext().getThread(), null).getValueString();
        }
        IJavaPrimitiveValue primitiveValue = (IJavaPrimitiveValue)value;
        switch (typeId) {
            case 5: {
                return Boolean.toString(primitiveValue.getBooleanValue());
            }
            case 3: {
                return Integer.toString(primitiveValue.getByteValue());
            }
            case 2: {
                return Character.toString(primitiveValue.getCharValue());
            }
            case 8: {
                return Double.toString(primitiveValue.getDoubleValue());
            }
            case 9: {
                return Float.toString(primitiveValue.getFloatValue());
            }
            case 10: {
                return Integer.toString(primitiveValue.getIntValue());
            }
            case 7: {
                return Long.toString(primitiveValue.getLongValue());
            }
            case 4: {
                return Integer.toString(primitiveValue.getShortValue());
            }
        }
        return NULL;
    }

    @Override
    protected boolean getBooleanResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        return false;
    }

    @Override
    protected double getDoubleResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        return ((IJavaPrimitiveValue)leftOperand).getDoubleValue() + ((IJavaPrimitiveValue)rightOperand).getDoubleValue();
    }

    @Override
    protected float getFloatResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        return ((IJavaPrimitiveValue)leftOperand).getFloatValue() + ((IJavaPrimitiveValue)rightOperand).getFloatValue();
    }

    @Override
    protected int getIntResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        return ((IJavaPrimitiveValue)leftOperand).getIntValue() + ((IJavaPrimitiveValue)rightOperand).getIntValue();
    }

    @Override
    protected long getLongResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        return ((IJavaPrimitiveValue)leftOperand).getLongValue() + ((IJavaPrimitiveValue)rightOperand).getLongValue();
    }

    @Override
    protected String getStringResult(IJavaValue leftOperand, IJavaValue rightOperand) throws CoreException {
        return this.getString(leftOperand, this.fLeftTypeId) + this.getString(rightOperand, this.fRightTypeId);
    }

    public String toString() {
        return InstructionsEvaluationMessages.PlusOperator______operator_2;
    }
}

