/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.internal.provisional.cheatsheets.IEditableTask;
import org.eclipse.ui.internal.provisional.cheatsheets.ITaskGroup;

public class TaskStateUtilities {
    public static ICompositeCheatSheetTask findBlockedAncestor(ICompositeCheatSheetTask task) {
        ITaskGroup parent = ((AbstractTask)task).getParent();
        if (parent == null) {
            return null;
        }
        if (!parent.requiredTasksCompleted()) {
            return parent;
        }
        return TaskStateUtilities.findBlockedAncestor(parent);
    }

    public static ICompositeCheatSheetTask findSkippedAncestor(ICompositeCheatSheetTask task) {
        ITaskGroup parent = ((AbstractTask)task).getParent();
        if (parent == null) {
            return null;
        }
        if (parent.getState() == 2) {
            return parent;
        }
        return TaskStateUtilities.findSkippedAncestor(parent);
    }

    public static ICompositeCheatSheetTask findCompletedAncestor(ICompositeCheatSheetTask task) {
        ITaskGroup parent = ((AbstractTask)task).getParent();
        if (parent == null) {
            return null;
        }
        if (parent.getState() == 3) {
            return parent;
        }
        return TaskStateUtilities.findCompletedAncestor(parent);
    }

    public static boolean isSkipEnabled(ICompositeCheatSheetTask task) {
        if (!task.isSkippable()) {
            return false;
        }
        if (task.getState() == 3) {
            return false;
        }
        if (task.getState() == 2) {
            return false;
        }
        if (TaskStateUtilities.findCompletedAncestor(task) != null) {
            return false;
        }
        return TaskStateUtilities.findSkippedAncestor(task) == null;
    }

    public static boolean isStartEnabled(ICompositeCheatSheetTask task) {
        if (!(task instanceof IEditableTask)) {
            return false;
        }
        return TaskStateUtilities.isStartable(task);
    }

    public static boolean isBlocked(ICompositeCheatSheetTask task) {
        return task.getState() == 0 && !TaskStateUtilities.isStartable(task);
    }

    private static boolean isStartable(ICompositeCheatSheetTask task) {
        if (task.getState() != 0) {
            return false;
        }
        if (TaskStateUtilities.findSkippedAncestor(task) != null) {
            return false;
        }
        if (TaskStateUtilities.findCompletedAncestor(task) != null) {
            return false;
        }
        if (!task.requiredTasksCompleted()) {
            return false;
        }
        return TaskStateUtilities.findBlockedAncestor(task) == null;
    }

    public static AbstractTask[] getRestartTasks(ICompositeCheatSheetTask task) {
        ArrayList<ICompositeCheatSheetTask> restartables = new ArrayList<ICompositeCheatSheetTask>();
        HashSet<ICompositeCheatSheetTask> visited = new HashSet<ICompositeCheatSheetTask>();
        TaskStateUtilities.addRestartableTasks(restartables, task, visited);
        return restartables.toArray(new AbstractTask[restartables.size()]);
    }

    private static void addRestartableTasks(List<ICompositeCheatSheetTask> restartables, ICompositeCheatSheetTask task, Set<ICompositeCheatSheetTask> visited) {
        ICompositeCheatSheetTask[] successors;
        if (visited.contains(task)) {
            return;
        }
        visited.add(task);
        if (task instanceof IEditableTask && task.getState() != 0) {
            restartables.add(task);
        } else if (task.getState() == 2) {
            restartables.add(task);
        }
        ICompositeCheatSheetTask[] children = task.getSubtasks();
        int i = 0;
        while (i < children.length) {
            TaskStateUtilities.addRestartableTasks(restartables, children[i], visited);
            ++i;
        }
        ICompositeCheatSheetTask[] iCompositeCheatSheetTaskArray = successors = ((AbstractTask)task).getSuccessorTasks();
        int n = successors.length;
        int n2 = 0;
        while (n2 < n) {
            ICompositeCheatSheetTask successor = iCompositeCheatSheetTaskArray[n2];
            int state = successor.getState();
            if (state == 3 || state == 1) {
                TaskStateUtilities.addRestartableTasks(restartables, successor, visited);
            }
            ++n2;
        }
    }
}

