/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.launching.JUnitLaunchRequirements;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.EclipsePluginValidationOperation;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.launching.launcher.RequirementHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.AbstractPluginBlock;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;

public class PluginBlock
extends AbstractPluginBlock {
    protected boolean fIsEnabled = false;
    protected boolean fInitDefaultCheckState = false;

    public PluginBlock(AbstractLauncherTab tab) {
        super(tab);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration config, boolean enableTable) throws CoreException {
        super.initializeButtonsFrom(config);
        if (this.fLaunchConfig != null && this.fLaunchConfig.equals(config) && this.fIsEnabled == enableTable) {
            return;
        }
        this.fIsEnabled = enableTable;
        super.initializeFrom(config, enableTable);
        if (enableTable) {
            this.initializePluginsState(config);
            if (this.fLaunchConfig.isWorkingCopy()) {
                this.savePluginState((ILaunchConfigurationWorkingCopy)this.fLaunchConfig);
            }
        }
        this.enableViewer(enableTable);
        this.updateCounter();
        this.fTab.updateLaunchConfigurationDialog();
    }

    public void initialize(boolean enable) throws CoreException {
        if (this.fLaunchConfig != null) {
            this.fInitDefaultCheckState = enable && !this.fLaunchConfig.hasAttribute("selected_workspace_bundles") && !this.fLaunchConfig.hasAttribute("selected_target_bundles");
            this.fTab.updateLaunchConfigurationDialog();
            this.initializeFrom(this.fLaunchConfig, enable);
        }
    }

    private void initializePluginsState(ILaunchConfiguration config) throws CoreException {
        Map selected = BundleLauncherHelper.getAllSelectedPluginBundles((ILaunchConfiguration)config);
        this.initializePluginsState(selected);
    }

    @Override
    protected boolean isEnabled() {
        return this.fIsEnabled;
    }

    @Override
    protected void savePluginState(ILaunchConfigurationWorkingCopy config) {
        if (this.isEnabled() || this.fInitDefaultCheckState) {
            IPluginModelBase[] workspaceModels;
            AbstractPluginBlock.PluginModelNameBuffer wBuffer = new AbstractPluginBlock.PluginModelNameBuffer();
            AbstractPluginBlock.PluginModelNameBuffer tBuffer = new AbstractPluginBlock.PluginModelNameBuffer();
            if (this.fInitDefaultCheckState) {
                IPluginModelBase[] externalModels;
                TreeSet<String> checkedWorkspace = new TreeSet<String>();
                IPluginModelBase[] iPluginModelBaseArray = workspaceModels = this.getWorkspaceModels();
                int n = workspaceModels.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginModelBase workspaceModel = iPluginModelBaseArray[n2];
                    String id = workspaceModel.getPluginBase().getId();
                    if (id != null) {
                        wBuffer.add(workspaceModel);
                        checkedWorkspace.add(id);
                    }
                    ++n2;
                }
                IPluginModelBase[] iPluginModelBaseArray2 = externalModels = this.getExternalModels();
                int n3 = externalModels.length;
                n = 0;
                while (n < n3) {
                    IPluginModelBase model = iPluginModelBaseArray2[n];
                    if (!checkedWorkspace.contains(model.getPluginBase().getId()) && model.isEnabled()) {
                        tBuffer.add(model);
                    }
                    ++n;
                }
                this.fInitDefaultCheckState = false;
            } else {
                Object[] selected;
                Object[] objectArray = selected = this.fPluginTreeViewer.getCheckedLeafElements();
                int n = selected.length;
                int externalModels = 0;
                while (externalModels < n) {
                    Object selectedElement = objectArray[externalModels];
                    if (selectedElement instanceof IPluginModelBase) {
                        IPluginModelBase model = (IPluginModelBase)selectedElement;
                        if (model.getUnderlyingResource() == null) {
                            tBuffer.add(model);
                        } else {
                            wBuffer.add(model);
                        }
                    }
                    ++externalModels;
                }
            }
            config.setAttribute("selected_workspace_bundles", wBuffer.getNameSet());
            config.setAttribute("selected_target_bundles", tBuffer.getNameSet());
            AbstractPluginBlock.PluginModelNameBuffer buffer = new AbstractPluginBlock.PluginModelNameBuffer();
            if (this.fAddWorkspaceButton.getSelection()) {
                workspaceModels = this.getWorkspaceModels();
                int i = 0;
                while (i < workspaceModels.length) {
                    if (!this.fPluginTreeViewer.isCheckedLeafElement(workspaceModels[i])) {
                        buffer.add(workspaceModels[i]);
                    }
                    ++i;
                }
            }
            config.setAttribute("deselected_workspace_bundles", buffer.getNameSet());
        }
    }

    @Override
    protected void addRequiredPlugins() {
        try {
            List requiredIds = RequirementHelper.getApplicationLaunchRequirements((ILaunchConfiguration)this.fLaunchConfig);
            Collection requiredPlugins = JUnitLaunchRequirements.getRequiredJunitRuntimeEclipsePlugins((ILaunchConfiguration)this.fLaunchConfig);
            Stream.concat(requiredPlugins.stream(), requiredIds.stream()).forEach(requiredId -> {
                IPluginModelBase base = this.findPlugin((String)requiredId);
                if (base == null && (base = PluginRegistry.findModel((String)requiredId)) != null) {
                    this.fPluginTreeViewer.setChecked(base, true);
                }
            });
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
        super.addRequiredPlugins();
    }

    @Override
    protected LaunchValidationOperation createValidationOperation() throws CoreException {
        Set models = BundleLauncherHelper.getMergedBundleMap((ILaunchConfiguration)this.fLaunchConfig, (boolean)false).keySet();
        return new EclipsePluginValidationOperation(this.fLaunchConfig, models);
    }
}

