/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.targetdefinition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.targetdefinition.TargetEditor;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ImplicitDependenciesSection
extends SectionPart {
    private TableViewer fViewer;
    private final TargetEditor fEditor;
    private Button fAdd;
    private Button fRemove;
    private Button fRemoveAll;
    private Label fCount;

    public ImplicitDependenciesSection(FormPage page, Composite parent) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.fEditor = (TargetEditor)page.getEditor();
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    private ITargetDefinition getTarget() {
        return this.fEditor.getTarget();
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setText(PDEUIMessages.ImplicitDependenicesSection_Title);
        section.setDescription(PDEUIMessages.TargetImplicitPluginsTab_desc);
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        container.setLayoutData((Object)new GridData(1808));
        this.createTableViewer(toolkit, container);
        Composite buttonComp = toolkit.createComposite(container);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(1040));
        this.createButtons(toolkit, buttonComp);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        GridData gd = new GridData(1808);
        section.setLayoutData((Object)gd);
        this.updateButtons();
    }

    private void createTableViewer(FormToolkit toolkit, Composite parent) {
        Table table = toolkit.createTable(parent, 770);
        table.setLayoutData((Object)new GridData(1808));
        this.fViewer = new TableViewer(table);
        this.fViewer.setContentProvider((IContentProvider)((IStructuredContentProvider)inputElement -> {
            Object[] bundles = this.getTarget().getImplicitDependencies();
            if (bundles == null) {
                return new NameVersionDescriptor[0];
            }
            return bundles;
        }));
        this.fViewer.setLabelProvider((IBaseLabelProvider)new StyledBundleLabelProvider(true, false));
        this.fViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                NameVersionDescriptor bundle1 = (NameVersionDescriptor)e1;
                NameVersionDescriptor bundle2 = (NameVersionDescriptor)e2;
                return super.compare(viewer, (Object)bundle1.getId(), (Object)bundle2.getId());
            }
        });
        this.fViewer.setInput((Object)this.getTarget());
        this.fViewer.addSelectionChangedListener(event -> this.updateButtons());
        this.fViewer.addDoubleClickListener(event -> {
            Object object = ((IStructuredSelection)event.getSelection()).getFirstElement();
            ManifestEditor.openPluginEditor(((NameVersionDescriptor)object).getId());
        });
    }

    private void createButtons(FormToolkit toolkit, Composite parent) {
        this.fAdd = toolkit.createButton(parent, PDEUIMessages.ImplicitDependenicesSection_Add, 8);
        this.fAdd.setLayoutData((Object)new GridData(770));
        this.fAdd.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleAdd()));
        SWTFactory.setButtonDimensionHint(this.fAdd);
        this.fRemove = toolkit.createButton(parent, PDEUIMessages.ImplicitDependenicesSection_Remove, 8);
        this.fRemove.setLayoutData((Object)new GridData(770));
        this.fRemove.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleRemove()));
        SWTFactory.setButtonDimensionHint(this.fRemove);
        this.fRemoveAll = toolkit.createButton(parent, PDEUIMessages.ImplicitDependenicesSection_RemoveAll, 8);
        this.fRemoveAll.setLayoutData((Object)new GridData(770));
        this.fRemoveAll.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleRemoveAll()));
        SWTFactory.setButtonDimensionHint(this.fRemoveAll);
        Composite countComp = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        countComp.setLayout((Layout)layout);
        countComp.setLayoutData((Object)new GridData(1816));
        this.fCount = toolkit.createLabel(parent, "");
        this.fCount.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fCount.setLayoutData((Object)new GridData(768));
    }

    private void updateButtons() {
        this.fRemove.setEnabled(!this.fViewer.getStructuredSelection().isEmpty());
        this.fRemoveAll.setEnabled(this.fViewer.getTable().getItemCount() > 0);
    }

    private void updateCount() {
        if (this.fCount != null && !this.fCount.isDisposed()) {
            this.fCount.setText(NLS.bind((String)PDEUIMessages.TableSection_itemCount, (Object)Integer.toString(this.fViewer.getTable().getItemCount())));
        }
    }

    protected void handleAdd() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new StyledBundleLabelProvider(false, false));
        dialog.setTitle(PDEUIMessages.PluginSelectionDialog_title);
        dialog.setMessage(PDEUIMessages.PluginSelectionDialog_message);
        dialog.setMultipleSelection(true);
        try {
            dialog.setElements((Object[])this.getValidBundles());
        }
        catch (CoreException e) {
            dialog.setMessage(e.getMessage());
        }
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.implicit_dependencies_selection_dialog");
        if (dialog.open() == 0) {
            Object[] models = dialog.getResult();
            ArrayList<NameVersionDescriptor> pluginsToAdd = new ArrayList<NameVersionDescriptor>();
            Object[] objectArray = models;
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                Object model = objectArray[n2];
                BundleInfo selected = (BundleInfo)model;
                pluginsToAdd.add(new NameVersionDescriptor(selected.getSymbolicName(), null));
                ++n2;
            }
            HashSet<NameVersionDescriptor> allDependencies = new HashSet<NameVersionDescriptor>();
            allDependencies.addAll(pluginsToAdd);
            NameVersionDescriptor[] currentBundles = this.getTarget().getImplicitDependencies();
            if (currentBundles != null) {
                allDependencies.addAll(Arrays.asList(currentBundles));
            }
            this.markDirty();
            this.getTarget().setImplicitDependencies(allDependencies.toArray(new NameVersionDescriptor[allDependencies.size()]));
            this.updateUI();
        }
    }

    protected BundleInfo[] getValidBundles() throws CoreException {
        NameVersionDescriptor[] current = this.getTarget().getImplicitDependencies();
        HashSet<String> currentBundles = new HashSet<String>();
        if (current != null) {
            NameVersionDescriptor[] nameVersionDescriptorArray = current;
            int n = current.length;
            int n2 = 0;
            while (n2 < n) {
                NameVersionDescriptor descriptor = nameVersionDescriptorArray[n2];
                currentBundles.add(descriptor.getId());
                ++n2;
            }
        }
        ArrayList<BundleInfo> targetBundles = new ArrayList<BundleInfo>();
        TargetBundle[] allTargetBundles = this.getTarget().getAllBundles();
        if (allTargetBundles == null || allTargetBundles.length == 0) {
            throw new CoreException(Status.warning((String)PDEUIMessages.ImplicitDependenciesSection_0));
        }
        int i = 0;
        while (i < allTargetBundles.length) {
            if (!currentBundles.contains(allTargetBundles[i].getBundleInfo().getSymbolicName())) {
                targetBundles.add(allTargetBundles[i].getBundleInfo());
            }
            ++i;
        }
        return targetBundles.toArray(new BundleInfo[targetBundles.size()]);
    }

    private void handleRemove() {
        LinkedList<NameVersionDescriptor> bundles = new LinkedList<NameVersionDescriptor>();
        bundles.addAll(Arrays.asList(this.getTarget().getImplicitDependencies()));
        Object[] removeBundles = this.fViewer.getStructuredSelection().toArray();
        if (removeBundles.length > 0) {
            Object[] objectArray = removeBundles;
            int n = removeBundles.length;
            int n2 = 0;
            while (n2 < n) {
                Object removeBundle = objectArray[n2];
                if (removeBundle instanceof NameVersionDescriptor) {
                    bundles.remove(removeBundle);
                }
                ++n2;
            }
            this.markDirty();
            this.getTarget().setImplicitDependencies(bundles.toArray(new NameVersionDescriptor[bundles.size()]));
            this.updateUI();
        }
    }

    private void handleRemoveAll() {
        this.markDirty();
        this.getTarget().setImplicitDependencies(null);
        this.updateUI();
    }

    public void refresh() {
        this.updateUI();
        super.refresh();
    }

    protected void updateUI() {
        this.fViewer.setInput((Object)this.getTarget());
        this.fViewer.refresh();
        this.updateButtons();
        this.updateCount();
    }
}

