/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.internal.core.util.BuildRunnable;
import org.eclipse.mylyn.builds.internal.core.util.BuildRunnableWithResult;
import org.eclipse.mylyn.builds.internal.core.util.Messages;

public class BuildRunner {
    private static void handleException(BuildRunnable code, Throwable exception) throws CoreException, OperationCanceledException {
        if (exception instanceof OperationCanceledException) {
            throw (OperationCanceledException)exception;
        }
        if (code.handleException(exception)) {
            return;
        }
        if (exception instanceof CoreException) {
            throw (CoreException)exception;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.builds.core", Messages.BuildRunner_unexpectedError, exception));
    }

    private static void handleException(BuildRunnableWithResult<?> code, Throwable exception) throws CoreException, OperationCanceledException {
        if (exception instanceof OperationCanceledException) {
            throw (OperationCanceledException)exception;
        }
        if (code.handleException(exception)) {
            return;
        }
        if (exception instanceof CoreException) {
            throw (CoreException)exception;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.builds.core", Messages.BuildRunner_unexpectedError, exception));
    }

    public static void run(BuildRunnable code) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)code);
        try {
            code.run();
        }
        catch (AssertionError | Exception | LinkageError e) {
            BuildRunner.handleException(code, (Throwable)e);
        }
    }

    public static <T> T run(BuildRunnableWithResult<T> code) throws CoreException, OperationCanceledException {
        Assert.isNotNull(code);
        try {
            return code.run();
        }
        catch (AssertionError | Exception | LinkageError e) {
            BuildRunner.handleException(code, (Throwable)e);
            throw new IllegalStateException(Messages.BuildRunner_unreachableCode);
        }
    }
}

