/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import org.eclipse.ecf.discovery.IServiceProperties;

public class ServiceProperties
implements IServiceProperties {
    private static final long serialVersionUID = -1033681952881598670L;
    private final Properties props;

    public ServiceProperties() {
        this.props = new Properties();
    }

    public ServiceProperties(Properties props) {
        this.props = props == null ? new Properties() : props;
    }

    public ServiceProperties(IServiceProperties sp) {
        this.props = new Properties();
        Enumeration names = sp.getPropertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            Object value = sp.getProperty(key);
            this.props.put(key, value);
        }
    }

    @Override
    public Enumeration getPropertyNames() {
        return this.props.keys();
    }

    @Override
    public String getPropertyString(String name) {
        Object val = this.props.get(name);
        if (val instanceof String) {
            return (String)val;
        }
        return null;
    }

    @Override
    public byte[] getPropertyBytes(String name) {
        Object val = this.props.get(name);
        if (val instanceof ByteArrayWrapper) {
            ByteArrayWrapper baw = (ByteArrayWrapper)val;
            return baw.getByte();
        }
        return null;
    }

    @Override
    public Object getProperty(String name) {
        return this.props.get(name);
    }

    @Override
    public Object setProperty(String name, Object value) {
        return this.props.put(name, value);
    }

    @Override
    public Object setPropertyBytes(String name, byte[] value) {
        return this.props.put(name, new ByteArrayWrapper(value));
    }

    @Override
    public Object setPropertyString(String name, String value) {
        return this.props.put(name, value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ServiceProperties) {
            ServiceProperties sp = (ServiceProperties)obj;
            return this.props.equals(sp.props);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.props.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ServiceProperties[");
        buf.append(this.props).append("]");
        return buf.toString();
    }

    @Override
    public int size() {
        return this.props.size();
    }

    public Properties asProperties() {
        Properties result = new Properties();
        Set<Object> keySet = this.props.keySet();
        for (Object key : keySet) {
            Object value = this.props.get(key);
            if (value instanceof ByteArrayWrapper) {
                ByteArrayWrapper baw = (ByteArrayWrapper)value;
                result.put(key, baw.getByte());
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    private static class ByteArrayWrapper
    implements Serializable {
        private static final long serialVersionUID = -8528836675536956297L;
        private final byte[] value;

        public ByteArrayWrapper(byte[] value) {
            this.value = value;
        }

        public byte[] getByte() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ByteArrayWrapper) {
                ByteArrayWrapper baw = (ByteArrayWrapper)obj;
                return Arrays.equals(this.value, baw.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

