/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dnd;

import org.eclipse.cdt.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class DelegatingDropAdapter
implements DropTargetListener {
    private TransferDropTargetListener[] fListeners;
    TransferDropTargetListener fCurrentListener;
    private int fOriginalDropType;

    public DelegatingDropAdapter(TransferDropTargetListener[] listeners) {
        Assert.isNotNull((Object)listeners);
        this.fListeners = listeners;
    }

    public void dragEnter(DropTargetEvent event) {
        this.fOriginalDropType = event.detail;
        this.updateCurrentListener(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.setCurrentListener(null, event);
    }

    public void dragOperationChanged(final DropTargetEvent event) {
        this.fOriginalDropType = event.detail;
        TransferDropTargetListener oldListener = this.getCurrentListener();
        this.updateCurrentListener(event);
        final TransferDropTargetListener newListener = this.getCurrentListener();
        if (newListener != null && newListener == oldListener) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    newListener.dragOperationChanged(event);
                }
            });
        }
    }

    public void dragOver(final DropTargetEvent event) {
        TransferDropTargetListener oldListener = this.getCurrentListener();
        this.updateCurrentListener(event);
        final TransferDropTargetListener newListener = this.getCurrentListener();
        if (newListener != null && newListener == oldListener) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    newListener.dragOver(event);
                }
            });
        }
    }

    public void drop(final DropTargetEvent event) {
        this.updateCurrentListener(event);
        if (this.getCurrentListener() != null) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.getCurrentListener().drop(event);
                }
            });
        }
        this.setCurrentListener(null, event);
    }

    public void dropAccept(final DropTargetEvent event) {
        if (this.getCurrentListener() != null) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.getCurrentListener().dropAccept(event);
                }
            });
        }
    }

    TransferDropTargetListener getCurrentListener() {
        return this.fCurrentListener;
    }

    private TransferData getSupportedTransferType(TransferData[] dataTypes, TransferDropTargetListener listener) {
        int i = 0;
        while (i < dataTypes.length) {
            if (listener.getTransfer().isSupportedType(dataTypes[i])) {
                return dataTypes[i];
            }
            ++i;
        }
        return null;
    }

    public Transfer[] getTransfers() {
        Transfer[] types = new Transfer[this.fListeners.length];
        int i = 0;
        while (i < this.fListeners.length) {
            types[i] = this.fListeners[i].getTransfer();
            ++i;
        }
        return types;
    }

    private boolean setCurrentListener(TransferDropTargetListener listener, final DropTargetEvent event) {
        if (this.fCurrentListener == listener) {
            return false;
        }
        if (this.fCurrentListener != null) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.fCurrentListener.dragLeave(event);
                }
            });
        }
        this.fCurrentListener = listener;
        if (this.fCurrentListener != null) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.fCurrentListener.dragEnter(event);
                }
            });
        }
        return true;
    }

    private void updateCurrentListener(DropTargetEvent event) {
        int originalDetail = event.detail;
        event.detail = this.fOriginalDropType;
        int i = 0;
        while (i < this.fListeners.length) {
            TransferDropTargetListener listener = this.fListeners[i];
            TransferData dataType = this.getSupportedTransferType(event.dataTypes, listener);
            if (dataType != null) {
                TransferData originalDataType = event.currentDataType;
                event.currentDataType = dataType;
                if (listener.isEnabled(event)) {
                    if (!this.setCurrentListener(listener, event)) {
                        event.detail = originalDetail;
                    }
                    return;
                }
                event.currentDataType = originalDataType;
            }
            ++i;
        }
        this.setCurrentListener(null, event);
        event.detail = 0;
    }
}

