/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.clipboard;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.extensions.core.BaseChart;

public class TextClipboardSupport {
    public static final String VALUE_DELIMITER = "\t";
    public static final String LINE_DELIMITER = "\r\n";

    public static void transfer(Display display, BaseChart baseChart) {
        ArrayList<String> seriesIds = new ArrayList<String>(baseChart.getSeriesIds());
        Collections.sort(seriesIds);
        ISeriesSet seriesSet = baseChart.getSeriesSet();
        StringBuilder builder = new StringBuilder();
        for (String seriesId : seriesIds) {
            ISeries series = seriesSet.getSeries(seriesId);
            builder.append("#");
            builder.append(seriesId);
            builder.append(LINE_DELIMITER);
            double[] x = series.getXSeries();
            double[] y = series.getYSeries();
            if (x.length != y.length) continue;
            int i = 0;
            while (i < x.length) {
                builder.append(x[i] + VALUE_DELIMITER + y[i]);
                builder.append(LINE_DELIMITER);
                ++i;
            }
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        Object[] data = new Object[]{builder.toString()};
        Transfer[] dataTypes = new Transfer[]{textTransfer};
        Clipboard clipboard = new Clipboard(display);
        try {
            clipboard.setContents(data, dataTypes);
        }
        finally {
            if (!clipboard.isDisposed()) {
                clipboard.dispose();
            }
        }
    }
}

