/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModel;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeModule;
import org.eclipse.scout.sdk.core.typescript.model.api.NodeModulesProvider;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeModuleSpi;

public final class ScoutJsModels {
    private static final Map<INodeModule, Optional<ScoutJsModel>> scoutJsModels = new ConcurrentHashMap<INodeModule, Optional<ScoutJsModel>>();

    private ScoutJsModels() {
    }

    static void onNodeModulesRemoved(Iterable<NodeModuleSpi> removed) {
        if (removed == null) {
            scoutJsModels.clear();
            return;
        }
        removed.forEach(removedModule -> scoutJsModels.keySet().removeIf(m -> m.spi() == removedModule));
    }

    public static Optional<ScoutJsModel> create(Path nodeModuleDir, Object context) {
        return NodeModulesProvider.createNodeModule((Path)nodeModuleDir, (Object)context).map(NodeModuleSpi::api).flatMap(ScoutJsModels::create);
    }

    public static Optional<ScoutJsModel> create(INodeModule module) {
        return ScoutJsModels.create(module, null);
    }

    static Optional<ScoutJsModel> create(INodeModule module, IES6Class widgetClass) {
        return Optional.ofNullable(module).flatMap(m -> ScoutJsModels.getOrCreate(m, widgetClass));
    }

    private static Optional<ScoutJsModel> getOrCreate(INodeModule module, IES6Class widgetClass) {
        return scoutJsModels.computeIfAbsent(module, m -> Optional.ofNullable(widgetClass).or(() -> ScoutJsModels.findWidgetClassInDependencies(m)).map(widget -> new ScoutJsModel((INodeModule)m, (IES6Class)widget)));
    }

    private static Optional<IES6Class> findWidgetClassInDependencies(INodeModule start) {
        return Optional.ofNullable(start).flatMap(ScoutJsModels::findScoutJsCoreModule).flatMap(m -> m.export("Widget")).map(IES6Class.class::cast);
    }

    private static Optional<INodeModule> findScoutJsCoreModule(INodeModule start) {
        return start.packageJson().dependencies().withSelf(true).withRecursive(true).withName("@eclipse-scout/core").first();
    }

    static {
        NodeModulesProvider.addListener(ScoutJsModels::onNodeModulesRemoved);
    }
}

