/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.eef.EEFContainerDescription;
import org.eclipse.eef.EEFControlDescription;
import org.eclipse.eef.EEFFillLayoutDescription;
import org.eclipse.eef.EEFGridLayoutDescription;
import org.eclipse.eef.EEFLayoutDescription;
import org.eclipse.eef.EEF_FILL_LAYOUT_ORIENTATION;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.EEFControlSwitch;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class EEFContainerLifecycleManager
implements IEEFLifecycleManager {
    private EEFContainerDescription description;
    private IInterpreter interpreter;
    private IVariableManager variableManager;
    private EditingContextAdapter contextAdapter;
    private List<IEEFLifecycleManager> lifecycleManagers = new ArrayList<IEEFLifecycleManager>();

    public EEFContainerLifecycleManager(EEFContainerDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        this.description = description;
        this.variableManager = variableManager;
        this.interpreter = interpreter;
        this.contextAdapter = editingContextAdapter;
    }

    @Override
    public void createControl(Composite parent, IEEFFormContainer formContainer) {
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        Composite composite = null;
        GridData gridData = null;
        if (this.isBorderedContainer()) {
            String borderLabel = this.getBorderLabel();
            composite = widgetFactory.createGroup(parent, borderLabel);
            gridData = new GridData(4, 0x1000000, true, false);
        } else {
            composite = widgetFactory.createComposite(parent);
            gridData = new GridData(768);
        }
        gridData.horizontalSpan = 3;
        composite.setLayoutData((Object)gridData);
        int numColumns = 1;
        boolean makeColumnsEqualWidth = true;
        EEFLayoutDescription layout = this.description.getLayout();
        if (layout instanceof EEFFillLayoutDescription) {
            EEFFillLayoutDescription fillLayoutDescription = (EEFFillLayoutDescription)layout;
            if (fillLayoutDescription.getOrientation() == EEF_FILL_LAYOUT_ORIENTATION.HORIZONTAL) {
                numColumns = this.description.getControls().size();
            }
        } else if (layout instanceof EEFGridLayoutDescription) {
            EEFGridLayoutDescription gridLayoutDescription = (EEFGridLayoutDescription)layout;
            numColumns = gridLayoutDescription.getNumberOfColumns();
            makeColumnsEqualWidth = gridLayoutDescription.isMakeColumnsWithEqualWidth();
        }
        GridLayout compositeLayout = new GridLayout(numColumns, makeColumnsEqualWidth);
        compositeLayout.marginWidth = 1;
        composite.setLayout((Layout)compositeLayout);
        EList controls = this.description.getControls();
        EEFControlSwitch eefControlSwitch = new EEFControlSwitch(this.interpreter, this.contextAdapter);
        int columnIndex = 0;
        while (columnIndex < numColumns) {
            Composite column = widgetFactory.createComposite(composite);
            GridData columnLayoutData = new GridData(4, 1, true, false);
            column.setLayoutData((Object)columnLayoutData);
            GridLayout columnLayout = new GridLayout(3, false);
            column.setLayout((Layout)columnLayout);
            int controlIndex = columnIndex;
            while (controlIndex < controls.size()) {
                EEFControlDescription eefControlDescription = (EEFControlDescription)controls.get(controlIndex);
                this.lifecycleManagers.addAll(eefControlSwitch.doCreate(column, formContainer, eefControlDescription, this.variableManager));
                controlIndex += numColumns;
            }
            ++columnIndex;
        }
    }

    protected String getBorderLabel() {
        return "";
    }

    protected boolean isBorderedContainer() {
        return false;
    }

    @Override
    public void aboutToBeShown() {
        this.lifecycleManagers.forEach(IEEFLifecycleManager::aboutToBeShown);
    }

    @Override
    public void refresh() {
        this.lifecycleManagers.forEach(IEEFLifecycleManager::refresh);
    }

    @Override
    public void aboutToBeHidden() {
        this.lifecycleManagers.forEach(IEEFLifecycleManager::aboutToBeHidden);
    }

    @Override
    public void dispose() {
        this.lifecycleManagers.forEach(IEEFLifecycleManager::dispose);
    }
}

