/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.preferences;

import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public final class PreferenceHelper {
    private PreferenceHelper() {
    }

    public static <T> T getPreference(IScopeContext projectScope, String qualifier, String sessionId, String preferenceKey, Class<T> preferenceType) {
        IScopeContext[] contexts = new IScopeContext[]{projectScope, InstanceScope.INSTANCE, ConfigurationScope.INSTANCE, DefaultScope.INSTANCE};
        String value = null;
        if (contexts[0] != null) {
            value = PreferenceHelper.getValueFromScope(contexts[0], qualifier + sessionId, preferenceKey);
        }
        if (value == null) {
            int i = 1;
            while (i < contexts.length) {
                value = PreferenceHelper.getValueFromScope(contexts[i], qualifier, preferenceKey);
                if (value != null) break;
                ++i;
            }
        }
        if (value != null && preferenceType.equals(Boolean.class)) {
            return (T)Boolean.valueOf(value);
        }
        return null;
    }

    private static String getValueFromScope(IScopeContext scope, String qualifier, String preferenceKey) {
        String value = scope.getNode(qualifier).get(preferenceKey, null);
        if (value != null && !(value = value.trim()).isEmpty()) {
            return value;
        }
        return null;
    }
}

