/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jenkins.core;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildFactory;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.core.spi.BuildConnector;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.internal.jenkins.core.JenkinsServerBehaviour;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsConfigurationCache;
import org.osgi.framework.Bundle;

public class JenkinsConnector
extends BuildConnector {
    private final JenkinsConfigurationCache cache;

    protected static File getCacheFile() {
        if (Platform.isRunning()) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.mylyn.jenkins.core");
            if (bundle == null) {
                bundle = Platform.getBundle((String)"org.eclipse.mylyn.hudson.core");
            }
            if (bundle != null) {
                IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
                IPath cacheFile = stateLocation.append("configuration.obj");
                return cacheFile.toFile();
            }
        }
        return null;
    }

    public JenkinsConnector() {
        this(JenkinsConnector.getCacheFile());
    }

    public JenkinsConnector(File cacheFile) {
        this.cache = new JenkinsConfigurationCache(cacheFile);
    }

    public JenkinsServerBehaviour getBehaviour(RepositoryLocation location) throws CoreException {
        return new JenkinsServerBehaviour(location, this.cache);
    }

    public IBuildElement getBuildElementFromUrl(IBuildServer server, String url) {
        Pattern p;
        Matcher matcher;
        if (url.startsWith(server.getUrl()) && (matcher = (p = Pattern.compile("(.*/job/(.*)/)(\\d+)")).matcher(url)).find()) {
            IBuildPlan plan = IBuildFactory.INSTANCE.createBuildPlan();
            plan.setServer(server);
            plan.setName(matcher.group(2));
            plan.setId(matcher.group(2));
            plan.setUrl(matcher.group(1));
            IBuild build = IBuildFactory.INSTANCE.createBuild();
            build.setId(matcher.group(3));
            build.setLabel(matcher.group(3));
            build.setPlan(plan);
            build.setUrl(url);
            return build;
        }
        return null;
    }
}

