/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.Set;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.ui.CElementSorter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class ProjectSelectionDialog
extends SelectionStatusDialog {
    private TableViewer fTableViewer;
    private Set<ICProject> fProjectsWithSpecifics;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private static final String DIALOG_SETTINGS_SHOW_ALL = "ProjectSelectionDialog.show_all";
    private ViewerFilter fFilter;

    public ProjectSelectionDialog(Shell parentShell, Set<ICProject> projectsWithSpecifics) {
        super(parentShell);
        this.setTitle(PreferencesMessages.ProjectSelectionDialog_title);
        this.setMessage(PreferencesMessages.ProjectSelectionDialog_desciption);
        this.fProjectsWithSpecifics = projectsWithSpecifics;
        this.fFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ProjectSelectionDialog.this.fProjectsWithSpecifics.contains(element);
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        composite.setFont(font);
        this.createMessageArea(composite);
        this.fTableViewer = new TableViewer(composite, 2816);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectSelectionDialog.this.doSelectionChanged(((IStructuredSelection)event.getSelection()).toArray());
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectSelectionDialog.this.okPressed();
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 250;
        data.widthHint = 300;
        this.fTableViewer.getTable().setLayoutData((Object)data);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new CElementLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new CElementContentProvider());
        this.fTableViewer.setComparator((ViewerComparator)new CElementSorter());
        this.fTableViewer.getControl().setFont(font);
        Button checkbox = new Button(composite, 32);
        checkbox.setText(PreferencesMessages.ProjectSelectionDialog_filter);
        checkbox.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        checkbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectSelectionDialog.this.updateFilter(((Button)e.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectSelectionDialog.this.updateFilter(((Button)e.widget).getSelection());
            }
        });
        IDialogSettings dialogSettings = CUIPlugin.getDefault().getDialogSettings();
        boolean doFilter = !dialogSettings.getBoolean(DIALOG_SETTINGS_SHOW_ALL) && !this.fProjectsWithSpecifics.isEmpty();
        checkbox.setSelection(doFilter);
        this.updateFilter(doFilter);
        ICModel input = CoreModel.getDefault().getCModel();
        this.fTableViewer.setInput((Object)input);
        this.doSelectionChanged(new Object[0]);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void updateFilter(boolean selected) {
        if (selected) {
            this.fTableViewer.addFilter(this.fFilter);
        } else {
            this.fTableViewer.removeFilter(this.fFilter);
        }
        CUIPlugin.getDefault().getDialogSettings().put(DIALOG_SETTINGS_SHOW_ALL, !selected);
    }

    private void doSelectionChanged(Object[] objects) {
        if (objects.length != 1) {
            this.updateStatus(new StatusInfo(4, ""));
            this.setSelectionResult(null);
        } else {
            this.updateStatus(new StatusInfo());
            this.setSelectionResult(objects);
        }
    }

    protected void computeResult() {
    }
}

