/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hierarchy;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.xtext.ide.editor.hierarchy.DefaultHierarchyRoot;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyRoot;
import org.eclipse.xtext.ui.editor.hierarchy.DeferredHierarchyBuilder;

public abstract class AbstractHierarchyViewPart
extends ViewPart {
    private IHierarchyBuilder builder;
    private URI rootURI;

    public void refresh(IProgressMonitor monitor) {
        this.setRoot(this.createRoot(monitor));
    }

    protected IHierarchyRoot createRoot(IProgressMonitor monitor) {
        if (this.builder == null || this.rootURI == null) {
            return IHierarchyRoot.EMPTY;
        }
        Collection roots = this.builder.buildRoots(this.rootURI, monitor);
        if (roots.isEmpty()) {
            return IHierarchyRoot.EMPTY;
        }
        DefaultHierarchyRoot root = new DefaultHierarchyRoot();
        root.getRoots().addAll(roots);
        return root;
    }

    protected abstract void setRoot(IHierarchyRoot var1);

    protected IHierarchyNode getSelectedNode(ISelection selection) {
        Object selectedElement;
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IHierarchyNode) {
            return (IHierarchyNode)selectedElement;
        }
        return null;
    }

    protected <T extends IHierarchyBuilder> T getBuilder(Class<T> clazz) {
        IHierarchyBuilder wrappedBuilder;
        if (clazz.isInstance(this.builder)) {
            return (T)((IHierarchyBuilder)clazz.cast(this.builder));
        }
        if (this.builder instanceof DeferredHierarchyBuilder && clazz.isInstance(wrappedBuilder = ((DeferredHierarchyBuilder)this.builder).getHierarchyBuilder())) {
            return (T)((IHierarchyBuilder)clazz.cast(wrappedBuilder));
        }
        return null;
    }

    protected IHierarchyBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(IHierarchyBuilder builder) {
        this.builder = builder;
    }

    protected URI getRootURI() {
        return this.rootURI;
    }

    public void setRootURI(URI rootURI) {
        this.rootURI = rootURI;
    }
}

