/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.text.XMLUtil;

public abstract class PDEHyperlinkDetector
implements IHyperlinkDetector {
    private final PDESourcePage fSourcePage;

    public PDEHyperlinkDetector(PDESourcePage page) {
        this.fSourcePage = page;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null) {
            return null;
        }
        IDocumentRange element = this.fSourcePage.getRangeElement(region.getOffset(), true);
        if (!XMLUtil.withinRange(element, region.getOffset())) {
            return null;
        }
        if (element instanceof IDocumentAttributeNode) {
            return this.detectAttributeHyperlink((IDocumentAttributeNode)element);
        }
        if (element instanceof IDocumentElementNode) {
            return this.detectNodeHyperlink((IDocumentElementNode)element);
        }
        if (element instanceof IDocumentTextNode) {
            return this.detectTextNodeHyperlink((IDocumentTextNode)element);
        }
        return null;
    }

    protected IHyperlink[] detectAttributeHyperlink(IDocumentAttributeNode attr) {
        return null;
    }

    protected IHyperlink[] detectNodeHyperlink(IDocumentElementNode node) {
        return null;
    }

    protected IHyperlink[] detectTextNodeHyperlink(IDocumentTextNode node) {
        return null;
    }
}

