/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor.compare;

import java.io.InputStream;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.genericeditor.ExtensionBasedTextViewerConfiguration;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class GenericEditorViewer
extends Viewer {
    private final SourceViewer sourceViewer;
    private IEditorInput editorInput;

    public GenericEditorViewer(Composite parent) {
        this.sourceViewer = new SourceViewer(parent, null, 768);
        this.sourceViewer.setEditable(false);
        this.sourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)TextMergeViewer.class.getName()));
        this.sourceViewer.getTextWidget().addDisposeListener(e -> this.disconnect());
    }

    public Control getControl() {
        return this.sourceViewer.getControl();
    }

    public Object getInput() {
        return this.editorInput;
    }

    public ISelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    public void refresh() {
    }

    public void setInput(Object input) {
        this.disconnect();
        if (!(input instanceof ITypedElement) || !(input instanceof IEncodedStreamContentAccessor)) {
            return;
        }
        Storage<ITypedElement> storage = new Storage<ITypedElement>((ITypedElement)((IEncodedStreamContentAccessor)input));
        this.editorInput = new StorageEditorInput((IStorage)storage);
        IDocumentProvider documentProvider = SharedDocumentAdapter.getDocumentProvider((IEditorInput)this.editorInput);
        try {
            documentProvider.connect((Object)this.editorInput);
        }
        catch (CoreException ex) {
            GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", ex.getMessage(), (Throwable)ex));
        }
        this.sourceViewer.setDocument(documentProvider.getDocument((Object)this.editorInput));
        ExtensionBasedTextViewerConfiguration configuration = new ExtensionBasedTextViewerConfiguration(null, (IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{EditorsUI.getPreferenceStore(), GenericEditorPlugin.getDefault().getPreferenceStore()}));
        this.sourceViewer.unconfigure();
        this.sourceViewer.configure((SourceViewerConfiguration)configuration);
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    private void disconnect() {
        if (this.editorInput != null) {
            this.sourceViewer.setDocument(null);
            SharedDocumentAdapter.getDocumentProvider((IEditorInput)this.editorInput).disconnect((Object)this.editorInput);
            this.editorInput = null;
        }
    }

    private static class Storage<T extends ITypedElement & IEncodedStreamContentAccessor>
    extends PlatformObject
    implements IEncodedStorage {
        private final T element;

        public Storage(T element) {
            this.element = element;
        }

        public InputStream getContents() throws CoreException {
            return ((IEncodedStreamContentAccessor)this.element).getContents();
        }

        public IPath getFullPath() {
            return null;
        }

        public String getName() {
            return this.element.getName();
        }

        public boolean isReadOnly() {
            return true;
        }

        public String getCharset() throws CoreException {
            return ((IEncodedStreamContentAccessor)this.element).getCharset();
        }
    }

    private static class StorageEditorInput
    extends PlatformObject
    implements IStorageEditorInput {
        private final IStorage storage;

        public StorageEditorInput(IStorage storage) {
            this.storage = storage;
        }

        public boolean exists() {
            return false;
        }

        public ImageDescriptor getImageDescriptor() {
            return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.storage.getName());
        }

        public String getName() {
            return this.storage.getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return this.storage.getName();
        }

        public IStorage getStorage() throws CoreException {
            return this.storage;
        }
    }
}

