"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceEditBuilder = void 0;
const lsp = require("vscode-languageserver-protocol");
class WorkspaceEditBuilder {
    #changes = {};
    #documentChanges = [];
    replace(resource, range, newText) {
        this.#addEdit(resource, lsp.TextEdit.replace(range, newText));
    }
    insert(resource, position, newText) {
        this.#addEdit(resource, lsp.TextEdit.insert(position, newText));
    }
    #addEdit(resource, edit) {
        const resourceKey = resource.toString();
        let edits = this.#changes[resourceKey];
        if (!edits) {
            edits = [];
            this.#changes[resourceKey] = edits;
        }
        edits.push(edit);
    }
    getEdit() {
        // We need to convert changes into `documentChanges` or else they get dropped
        const textualChanges = Object.entries(this.#changes).map(([uri, edits]) => {
            return lsp.TextDocumentEdit.create({ uri, version: null }, edits);
        });
        return {
            documentChanges: [...textualChanges, ...this.#documentChanges],
        };
    }
    renameFile(targetUri, resolvedNewFilePath) {
        this.#documentChanges.push(lsp.RenameFile.create(targetUri.toString(), resolvedNewFilePath.toString()));
    }
}
exports.WorkspaceEditBuilder = WorkspaceEditBuilder;
//# sourceMappingURL=editBuilder.js.map