/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.CompositeReaderContext;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;

public final class LeafReaderContext
extends IndexReaderContext {
    public final int ord;
    public final int docBase;
    private final LeafReader reader;
    private final List<LeafReaderContext> leaves;

    LeafReaderContext(CompositeReaderContext parent, LeafReader reader, int ord, int docBase, int leafOrd, int leafDocBase) {
        super(parent, ord, docBase);
        this.ord = leafOrd;
        this.docBase = leafDocBase;
        this.reader = reader;
        this.leaves = this.isTopLevel ? Collections.singletonList(this) : null;
    }

    LeafReaderContext(LeafReader leafReader) {
        this(null, leafReader, 0, 0, 0, 0);
    }

    @Override
    public List<LeafReaderContext> leaves() {
        if (!this.isTopLevel) {
            throw new UnsupportedOperationException("This is not a top-level context.");
        }
        assert (this.leaves != null);
        return this.leaves;
    }

    @Override
    public List<IndexReaderContext> children() {
        return null;
    }

    @Override
    public LeafReader reader() {
        return this.reader;
    }

    public String toString() {
        return "LeafReaderContext(" + String.valueOf(this.reader) + " docBase=" + this.docBase + " ord=" + this.ord + ")";
    }
}

