/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.internal.builds.ui.actions.AbortBuildAction;
import org.eclipse.mylyn.internal.builds.ui.actions.AbortBuildFromEditorAction;
import org.eclipse.mylyn.internal.builds.ui.actions.NewTaskFromBuildAction;
import org.eclipse.mylyn.internal.builds.ui.actions.RefreshBuildEditorAction;
import org.eclipse.mylyn.internal.builds.ui.actions.RunBuildAction;
import org.eclipse.mylyn.internal.builds.ui.actions.ShowHistoryAction;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildDetailsPage;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditorInput;
import org.eclipse.mylyn.internal.builds.ui.editor.Messages;
import org.eclipse.mylyn.internal.builds.ui.view.BuildLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class BuildEditor
extends SharedHeaderFormEditor {
    private IBuildPlan plan;
    private IBuild build;
    private BuildDetailsPage buildDetailsPage;
    private boolean isDisposed;
    private RunBuildAction runBuildAction;
    private AbortBuildAction abortBuildAction;
    private ShowHistoryAction historyAction;
    private NewTaskFromBuildAction newTaskFromBuildAction;
    private RefreshBuildEditorAction refreshAction;

    protected void addPages() {
        this.buildDetailsPage = new BuildDetailsPage((FormEditor)this, Messages.BuildEditor_details);
        try {
            this.addPage((IFormPage)this.buildDetailsPage);
        }
        catch (PartInitException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", "Could not create Build editor.", (Throwable)e));
        }
        this.setActivePage(0);
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.getToolkit().decorateFormHeading(headerForm.getForm().getForm());
        EditorUtil.initializeScrollbars((ScrolledForm)this.getHeaderForm().getForm());
        this.updateHeader();
        this.fillToolBar();
        this.updateToolBarActions();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public BuildEditorInput getEditorInput() {
        return (BuildEditorInput)super.getEditorInput();
    }

    public IBuildPlan getPlan() {
        return this.plan;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof BuildEditorInput)) {
            throw new PartInitException("Unsupported class for editor input ''" + String.valueOf(input.getClass()) + "''");
        }
        super.init(site, input);
        this.plan = ((BuildEditorInput)input).getPlan();
        this.build = ((BuildEditorInput)input).getBuild();
        this.setPartName(input.getName());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void updateHeader() {
        String title;
        Image image;
        BuildEditorInput input = this.getEditorInput();
        if (input.getBuild() != null) {
            image = CommonImages.getImage((ImageDescriptor)BuildLabelProvider.getImageDescriptor(input.getBuild().getStatus()));
            title = NLS.bind((String)Messages.BuildEditor_buildLabel, (Object)input.getBuild().getLabel());
        } else {
            image = CommonImages.getImage((ImageDescriptor)BuildsUi.getConnectorUi(this.plan.getServer()).getImageDescriptor());
            title = Messages.BuildEditor_build;
        }
        switch (this.getEditorInput().getBuildInfo()) {
            case PARTIAL: {
                title = NLS.bind((String)Messages.BuildEditor_retrievingBuild, (Object)title);
                break;
            }
            case ERROR: {
                title = NLS.bind((String)Messages.BuildEditor_failedToRetrieveBuildInformation, (Object)title);
                image = CommonImages.getImage((ImageDescriptor)CommonImages.ERROR);
            }
        }
        this.getHeaderForm().getForm().setText(title);
        this.getHeaderForm().getForm().setImage(image);
        this.setTitleToolTip(input.getToolTipText());
        this.setPartName(input.getName());
    }

    private void fillToolBar() {
        Form form = this.getHeaderForm().getForm().getForm();
        IToolBarManager toolBarManager = form.getToolBarManager();
        toolBarManager.add((IContributionItem)new GroupMarker("group.file"));
        this.refreshAction = new RefreshBuildEditorAction(this);
        toolBarManager.add((IAction)this.refreshAction);
        this.runBuildAction = new RunBuildAction();
        toolBarManager.add((IAction)this.runBuildAction);
        this.abortBuildAction = new AbortBuildFromEditorAction(this);
        toolBarManager.add((IAction)this.abortBuildAction);
        this.historyAction = new ShowHistoryAction();
        toolBarManager.add((IAction)this.historyAction);
        toolBarManager.add((IContributionItem)new Separator("group.edit"));
        if (this.getEditorInput().getBuild() != null) {
            this.newTaskFromBuildAction = new NewTaskFromBuildAction();
            toolBarManager.add((IAction)this.newTaskFromBuildAction);
        }
        toolBarManager.add((IContributionItem)new Separator("group.open"));
        Action openWithBrowserAction = new Action(){

            public void run() {
                if (BuildEditor.this.build != null) {
                    BrowserUtil.openUrl((String)BuildEditor.this.build.getUrl(), (int)131072);
                } else {
                    BrowserUtil.openUrl((String)BuildEditor.this.plan.getUrl(), (int)131072);
                }
            }
        };
        openWithBrowserAction.setImageDescriptor(CommonImages.WEB);
        openWithBrowserAction.setToolTipText(Messages.BuildEditor_openWithWebBrowser);
        toolBarManager.add((IAction)openWithBrowserAction);
        toolBarManager.update(true);
    }

    protected void updateToolBarActions() {
        this.runBuildAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getEditorInput().getPlan()));
        this.abortBuildAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getEditorInput().getBuild()));
        this.historyAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getEditorInput().getPlan()));
        if (this.newTaskFromBuildAction != null) {
            this.newTaskFromBuildAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getEditorInput().getBuild()));
        }
        this.refreshAction.updateEnablement();
    }

    public void refresh() {
        this.build = this.getEditorInput().getBuild();
        this.plan = this.getEditorInput().getPlan();
        this.buildDetailsPage.refresh();
        this.updateHeader();
        this.updateToolBarActions();
    }

    public void dispose() {
        this.isDisposed = true;
        super.dispose();
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }
}

