/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.util.HashSet;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.JNIParameter;
import org.eclipse.swt.tools.internal.JNIType;

public class NativesGenerator
extends JNIGenerator {
    boolean enterExitMacro = true;

    @Override
    public void generateCopyright() {
        this.outputln(this.fixDelimiter(this.getMetaData().getCopyright()));
    }

    @Override
    public void generateIncludes() {
        String outputName = this.getOutputName();
        this.outputln("#include \"swt.h\"");
        this.output("#include \"");
        this.output(outputName);
        this.outputln("_structs.h\"");
        this.output("#include \"");
        this.output(outputName);
        this.outputln("_stats.h\"");
        if (outputName.equals("gtk3") || outputName.equals("gtk4")) {
            this.outputln("#include \"os_structs.h\"");
        }
        this.outputln();
    }

    public void generate(JNIClass clazz, String methodName) {
        JNIMethod[] methods = clazz.getDeclaredMethods();
        int count = 0;
        JNIMethod[] jNIMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            JNIMethod method = jNIMethodArray[n2];
            if (method.getName().startsWith(methodName)) {
                ++count;
            }
            ++n2;
        }
        JNIMethod[] result = new JNIMethod[count];
        count = 0;
        JNIMethod[] jNIMethodArray2 = methods;
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            JNIMethod method = jNIMethodArray2[n];
            if (method.getName().startsWith(methodName)) {
                result[count++] = method;
            }
            ++n;
        }
        this.generate(result);
    }

    @Override
    public void generate(JNIClass clazz) {
        JNIMethod[] methods = clazz.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            JNIMethod method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) break;
            ++i;
        }
        if (i == methods.length) {
            return;
        }
        NativesGenerator.sort(methods);
        this.generateNativeMacro(clazz);
        this.generateWarningSettings();
        this.generateExcludes(methods);
        this.generate(methods);
    }

    public void generate(JNIMethod[] methods) {
        NativesGenerator.sort(methods);
        JNIMethod[] jNIMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            JNIMethod method = jNIMethodArray[n2];
            if ((method.getModifiers() & 0x100) != 0) {
                this.generate(method);
                if (this.progress != null) {
                    this.progress.step();
                }
            }
            ++n2;
        }
    }

    boolean isStruct(String flagsStr) {
        String[] stringArray = NativesGenerator.split(flagsStr, " ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String flag = stringArray[n2];
            if (flag.equals("struct")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isFloatingPoint(String type) {
        return type.equals("float") || type.equals("double");
    }

    void generateCallback(JNIMethod method, String function) {
        this.output("static jlong ");
        this.output(function);
        this.outputln(";");
        this.output("static ");
        String[] types = NativesGenerator.split((String)method.getParam("callback_types"), ";");
        String[] flags = NativesGenerator.split((String)method.getParam("callback_flags"), ";");
        this.output(types[0]);
        this.output(" ");
        this.output("proc_");
        this.output(function);
        this.output("(");
        boolean first = true;
        int i = 1;
        while (i < types.length) {
            if (!first) {
                this.output(", ");
            }
            this.output(types[i]);
            this.output(" ");
            this.output("arg");
            this.output(String.valueOf(i - 1));
            first = false;
            ++i;
        }
        this.outputln(") {");
        this.output("\t");
        if (this.isStruct(flags[0]) || this.isFloatingPoint(types[0])) {
            this.output(types[0]);
            this.output("* lprc = ");
        } else if (!types[0].equals("void")) {
            this.output("return ");
        }
        this.output("((");
        this.output(types[0]);
        if (this.isStruct(flags[0]) || this.isFloatingPoint(types[0])) {
            this.output("*");
        }
        this.output(" (*)(");
        first = true;
        i = 1;
        while (i < types.length) {
            if (!first) {
                this.output(", ");
            }
            first = false;
            this.output(types[i]);
            if (this.isStruct(flags[i]) || this.isFloatingPoint(types[i])) {
                this.output("*");
            }
            ++i;
        }
        this.output("))");
        this.output(function);
        this.output(")(");
        first = true;
        i = 1;
        while (i < types.length) {
            if (!first) {
                this.output(", ");
            }
            first = false;
            if (this.isStruct(flags[i]) || this.isFloatingPoint(types[i])) {
                this.output("&");
            }
            this.output("arg");
            this.output(String.valueOf(i - 1));
            ++i;
        }
        this.outputln(");");
        if (this.isStruct(flags[0]) || this.isFloatingPoint(types[0])) {
            this.output("\t");
            this.output(types[0]);
            this.outputln(" rc;");
            this.outputln("\tif (lprc) {");
            this.outputln("\t\trc = *lprc;");
            this.outputln("\t\tfree(lprc);");
            this.outputln("\t} else {");
            this.output("\t\tmemset(&rc, 0, sizeof(");
            this.output(types[0]);
            this.outputln("));");
            this.outputln("\t}");
            this.outputln("\treturn rc;");
        }
        this.outputln("}");
        this.output("static jlong ");
        this.output(method.getName());
        this.outputln("(jlong func) {");
        this.output("\t");
        this.output(function);
        this.outputln(" = func;");
        this.output("\treturn (jlong)proc_");
        this.output(function);
        this.outputln(";");
        this.outputln("}");
    }

    public void generate(JNIMethod method) {
        if (method.getFlag("no_gen")) {
            return;
        }
        JNIType returnType = method.getReturnType();
        if (!(returnType.isType("void") || returnType.isPrimitive() || this.isSystemClass(returnType) || returnType.isType("java.lang.String"))) {
            this.output("Warning: bad return type. :");
            this.outputln(method.toString());
            return;
        }
        JNIParameter[] params = method.getParameters();
        String function = NativesGenerator.getFunctionName(method);
        this.generateSourceStart(function);
        this.generateIgnoreDeprecationsStart(method);
        boolean isCPP = this.getCPP();
        if (isCPP) {
            this.output("extern \"C\" ");
            this.generateFunctionPrototype(method, function, params, returnType, true);
            this.outputln(";");
        }
        if (function.startsWith("CALLBACK_")) {
            this.generateCallback(method, function);
        }
        this.generateFunctionPrototype(method, function, params, returnType, false);
        this.generateFunctionBody(method, function, params, returnType);
        this.generateIgnoreDeprecationsEnd(method);
        this.generateSourceEnd();
        this.outputln();
    }

    public void setEnterExitMacro(boolean enterExitMacro) {
        this.enterExitMacro = enterExitMacro;
    }

    void generateExcludes(JNIMethod[] methods) {
        HashSet<String> excludes = new HashSet<String>();
        JNIMethod[] jNIMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String exclude;
            JNIMethod method = jNIMethodArray[n2];
            if ((method.getModifiers() & 0x100) != 0 && (exclude = method.getExclude()).length() != 0) {
                excludes.add(exclude);
            }
            ++n2;
        }
        for (String exclude : excludes) {
            this.outputln(exclude);
            JNIMethod[] jNIMethodArray2 = methods;
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                String methodExclude;
                JNIMethod method = jNIMethodArray2[n4];
                if ((method.getModifiers() & 0x100) != 0 && exclude.equals(methodExclude = method.getExclude())) {
                    this.output("#define NO_");
                    this.outputln(NativesGenerator.getFunctionName(method));
                }
                ++n4;
            }
            this.outputln("#endif");
            this.outputln();
        }
    }

    void generateNativeMacro(JNIClass clazz) {
        this.output("#ifndef ");
        this.output(clazz.getSimpleName());
        this.outputln("_NATIVE");
        this.output("#define ");
        this.output(clazz.getSimpleName());
        this.output("_NATIVE(func) Java_");
        this.output(NativesGenerator.toC(clazz.getName()));
        this.outputln("_##func");
        this.outputln("#endif");
        this.outputln();
    }

    void generateWarningSettings() {
        this.outputln("#ifdef _WIN32");
        this.outputln("  /* Many methods don't use their 'env' and 'that' arguments */");
        this.outputln("  #pragma warning (disable: 4100)");
        this.outputln("#endif");
        this.outputln();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean generateGetParameter(JNIParameter param, boolean critical, int indent) {
        JNIType paramType = param.getType();
        if (paramType.isPrimitive() || this.isSystemClass(paramType)) {
            return false;
        }
        String iStr = String.valueOf(param.getParameter());
        int j = 0;
        while (j < indent) {
            this.output("\t");
            ++j;
        }
        this.output("if (arg");
        this.output(iStr);
        this.output(") if ((lparg");
        this.output(iStr);
        this.output(" = ");
        boolean isCPP = this.getCPP();
        if (paramType.isArray()) {
            JNIType componentType = paramType.getComponentType();
            if (componentType.isPrimitive()) {
                if (critical) {
                    if (isCPP) {
                        this.output("(");
                        this.output(componentType.getTypeSignature2());
                        this.output("*)");
                        this.output("env->GetPrimitiveArrayCritical(arg");
                    } else {
                        this.output("(*env)->GetPrimitiveArrayCritical(env, arg");
                    }
                    this.output(iStr);
                    this.output(", NULL)");
                } else {
                    if (isCPP) {
                        this.output("env->Get");
                    } else {
                        this.output("(*env)->Get");
                    }
                    this.output(componentType.getTypeSignature1());
                    if (isCPP) {
                        this.output("ArrayElements(arg");
                    } else {
                        this.output("ArrayElements(env, arg");
                    }
                    this.output(iStr);
                    this.output(", NULL)");
                }
            } else {
                if (!componentType.isType("java.lang.String")) throw new Error("not done");
                if (param.getFlag("unicode")) {
                    throw new Error("not done");
                }
                this.output("swt_getArrayOfStringsUTF(env, arg");
                this.output(iStr);
                this.output(")");
            }
        } else if (paramType.isType("java.lang.String")) {
            if (param.getFlag("unicode")) {
                if (isCPP) {
                    this.output("env->GetStringChars(arg");
                } else {
                    this.output("(*env)->GetStringChars(env, arg");
                }
                this.output(iStr);
                this.output(", NULL)");
            } else {
                if (isCPP) {
                    this.output("env->GetStringUTFChars(arg");
                } else {
                    this.output("(*env)->GetStringUTFChars(env, arg");
                }
                this.output(iStr);
                this.output(", NULL)");
            }
        } else if (param.getFlag("no_in")) {
            this.output("&_arg");
            this.output(iStr);
        } else {
            this.output("get");
            this.output(paramType.getSimpleName());
            this.output("Fields(env, arg");
            this.output(iStr);
            this.output(", &_arg");
            this.output(iStr);
            this.output(")");
        }
        this.outputln(") == NULL) goto fail;");
        return true;
    }

    void generateSetParameter(JNIParameter param, boolean critical) {
        JNIType paramType = param.getType();
        if (paramType.isPrimitive() || this.isSystemClass(paramType)) {
            return;
        }
        String iStr = String.valueOf(param.getParameter());
        boolean isCPP = this.getCPP();
        if (paramType.isArray()) {
            this.output("\tif (arg");
            this.output(iStr);
            this.output(" && lparg");
            this.output(iStr);
            this.output(") ");
            JNIType componentType = paramType.getComponentType();
            if (componentType.isPrimitive()) {
                if (critical) {
                    if (isCPP) {
                        this.output("env->ReleasePrimitiveArrayCritical(arg");
                    } else {
                        this.output("(*env)->ReleasePrimitiveArrayCritical(env, arg");
                    }
                    this.output(iStr);
                } else {
                    if (isCPP) {
                        this.output("env->Release");
                    } else {
                        this.output("(*env)->Release");
                    }
                    this.output(componentType.getTypeSignature1());
                    if (isCPP) {
                        this.output("ArrayElements(arg");
                    } else {
                        this.output("ArrayElements(env, arg");
                    }
                    this.output(iStr);
                }
                this.output(", lparg");
                this.output(iStr);
                this.output(", ");
                if (param.getFlag("no_out")) {
                    this.output("JNI_ABORT");
                } else {
                    this.output("0");
                }
                this.output(");");
            } else if (componentType.isType("java.lang.String")) {
                if (param.getFlag("unicode")) {
                    throw new Error("not done");
                }
                this.output("swt_releaseArrayOfStringsUTF(env, arg");
                this.output(iStr);
                this.output(", lparg");
                this.output(iStr);
                this.output(");");
            } else {
                throw new Error("not done");
            }
            this.outputln();
        } else if (paramType.isType("java.lang.String")) {
            this.output("\tif (arg");
            this.output(iStr);
            this.output(" && lparg");
            this.output(iStr);
            this.output(") ");
            if (param.getFlag("unicode")) {
                if (isCPP) {
                    this.output("env->ReleaseStringChars(arg");
                } else {
                    this.output("(*env)->ReleaseStringChars(env, arg");
                }
            } else if (isCPP) {
                this.output("env->ReleaseStringUTFChars(arg");
            } else {
                this.output("(*env)->ReleaseStringUTFChars(env, arg");
            }
            this.output(iStr);
            this.output(", lparg");
            this.output(iStr);
            this.outputln(");");
        } else if (!param.getFlag("no_out")) {
            this.output("\tif (arg");
            this.output(iStr);
            this.output(" && lparg");
            this.output(iStr);
            this.output(") ");
            this.output("set");
            this.output(paramType.getSimpleName());
            this.output("Fields(env, arg");
            this.output(iStr);
            this.output(", lparg");
            this.output(iStr);
            this.outputln(");");
        }
    }

    void generateEnterExitMacro(JNIMethod method, String function, boolean enter) {
        if (!this.enterExitMacro) {
            return;
        }
        boolean tryCatch = method.getFlag("trycatch");
        this.output("\t");
        this.output(method.getDeclaringClass().getSimpleName());
        this.output("_NATIVE_");
        this.output(enter ? "ENTER" : "EXIT");
        if (tryCatch) {
            this.output(enter ? "_TRY" : "_CATCH");
        }
        this.output("(env, that, ");
        this.output(function);
        this.outputln("_FUNC);");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean generateLocalVars(JNIParameter[] params, JNIType returnType) {
        boolean needsReturn = this.enterExitMacro;
        int i = 0;
        while (i < params.length) {
            JNIParameter param = params[i];
            JNIType paramType = param.getType();
            if (!paramType.isPrimitive() && !this.isSystemClass(paramType)) {
                this.output("\t");
                if (paramType.isArray()) {
                    JNIType componentType = paramType.getComponentType();
                    if (componentType.isPrimitive()) {
                        this.output(componentType.getTypeSignature2());
                        this.output(" *lparg" + i);
                        this.output("=NULL;");
                    } else {
                        if (!componentType.isType("java.lang.String")) throw new Error("not done");
                        if (param.getFlag("unicode")) {
                            this.output("jchar **lparg" + i + "=NULL");
                        } else {
                            this.output("char **lparg" + i + "=NULL");
                        }
                    }
                } else if (paramType.isType("java.lang.String")) {
                    if (param.getFlag("unicode")) {
                        this.output("const jchar *lparg" + i);
                    } else {
                        this.output("const char *lparg" + i);
                    }
                    this.output("= NULL;");
                } else {
                    if (param.getTypeClass().getFlag("struct")) {
                        this.output("struct ");
                    }
                    this.output(paramType.getSimpleName());
                    this.output(" _arg" + i);
                    if (param.getFlag("init")) {
                        this.output("={0}");
                    }
                    this.output(", *lparg" + i);
                    this.output("=NULL;");
                }
                this.outputln();
                needsReturn = true;
            }
            ++i;
        }
        if (!needsReturn || returnType.isType("void")) return needsReturn;
        this.output("\t");
        this.output(returnType.getTypeSignature2());
        this.outputln(" rc = 0;");
        return needsReturn;
    }

    boolean generateGetters(JNIParameter[] params) {
        JNIParameter param;
        boolean genFailTag = false;
        int criticalCount = 0;
        JNIParameter[] jNIParameterArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            param = jNIParameterArray[n2];
            if (!this.isCritical(param)) {
                genFailTag |= this.generateGetParameter(param, false, 1);
            } else {
                ++criticalCount;
            }
            ++n2;
        }
        if (criticalCount != 0) {
            jNIParameterArray = params;
            n = params.length;
            n2 = 0;
            while (n2 < n) {
                param = jNIParameterArray[n2];
                if (this.isCritical(param)) {
                    genFailTag |= this.generateGetParameter(param, true, 2);
                }
                ++n2;
            }
        }
        return genFailTag;
    }

    void generateSetters(JNIParameter[] params) {
        JNIParameter param;
        int criticalCount = 0;
        int i = params.length - 1;
        while (i >= 0) {
            param = params[i];
            if (this.isCritical(param)) {
                ++criticalCount;
            }
            --i;
        }
        if (criticalCount != 0) {
            i = params.length - 1;
            while (i >= 0) {
                param = params[i];
                if (this.isCritical(param)) {
                    this.output("\t");
                    this.generateSetParameter(param, true);
                }
                --i;
            }
        }
        i = params.length - 1;
        while (i >= 0) {
            param = params[i];
            if (!this.isCritical(param)) {
                this.generateSetParameter(param, false);
            }
            --i;
        }
    }

    void generateDynamicFunctionCall(JNIMethod method, JNIParameter[] params, JNIType returnType, boolean needsReturn) {
        this.outputln("/*");
        this.generateFunctionCall(method, params, returnType, needsReturn);
        this.outputln("*/");
        this.outputln("\t{");
        String name = method.getName();
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        this.output("\t\t");
        this.output(method.getDeclaringClass().getSimpleName());
        this.output("_LOAD_FUNCTION(fp, ");
        this.output(name);
        this.outputln(")");
        this.outputln("\t\tif (fp) {");
        this.output("\t\t");
        this.generateFunctionCallLeftSide(method, returnType, needsReturn);
        this.output("((");
        this.output(returnType.getTypeSignature2());
        this.output(" (CALLING_CONVENTION*)(");
        int i = 0;
        while (i < params.length) {
            if (i != 0) {
                this.output(", ");
            }
            JNIParameter param = params[i];
            String cast = param.getCast();
            boolean isStruct = param.getFlag("struct");
            if (cast.length() > 2) {
                int index;
                cast = cast.substring(1, cast.length() - 1);
                if (isStruct && (index = cast.lastIndexOf(42)) != -1) {
                    cast = cast.substring(0, index).trim();
                }
                this.output(cast);
            } else {
                JNIType paramType = param.getType();
                this.output(paramType.getTypeSignature4(isStruct));
            }
            ++i;
        }
        this.output("))");
        this.output("fp");
        this.output(")");
        this.generateFunctionCallRightSide(method, params, 0);
        this.output(";");
        this.outputln();
        this.outputln("\t\t}");
        this.outputln("\t}");
    }

    void generateFunctionCallLeftSide(JNIMethod method, JNIType returnType, boolean needsReturn) {
        this.output("\t");
        if (!returnType.isType("void")) {
            if (needsReturn) {
                this.output("rc = ");
            } else {
                this.output("return ");
            }
            this.output("(");
            this.output(returnType.getTypeSignature2());
            this.output(")");
        }
        if (method.getFlag("address")) {
            this.output("&");
        }
        if (method.getFlag("jni")) {
            boolean isCPP = this.getCPP();
            this.output(isCPP ? "env->" : "(*env)->");
        }
    }

    void generateFunctionCallRightSide(JNIMethod method, JNIParameter[] params, int paramStart) {
        if (!method.getFlag("const")) {
            boolean isCPP;
            this.output("(");
            if (method.getFlag("jni") && !(isCPP = this.getCPP())) {
                this.output("env, ");
            }
            int i = paramStart;
            while (i < params.length) {
                JNIParameter param = params[i];
                if (i != paramStart) {
                    this.output(", ");
                }
                if (param.getFlag("struct")) {
                    this.output("*");
                }
                this.output(param.getCast());
                if (param.getFlag("object")) {
                    this.output("TO_OBJECT(");
                }
                if (i == params.length - 1 && param.getFlag("sentinel")) {
                    this.output("NULL");
                } else {
                    JNIType paramType = param.getType();
                    if (!paramType.isPrimitive() && !this.isSystemClass(paramType)) {
                        this.output("lp");
                    }
                    this.output("arg" + i);
                }
                if (param.getFlag("object")) {
                    this.output(")");
                }
                ++i;
            }
            this.output(")");
        }
    }

    void generateFunctionCall(JNIMethod method, JNIParameter[] params, JNIType returnType, boolean needsReturn) {
        boolean makeCopy;
        String name = method.getName();
        String copy = (String)method.getParam("copy");
        boolean isCPP = this.getCPP();
        boolean bl = makeCopy = copy.length() != 0 && isCPP && !returnType.isType("void");
        if (makeCopy) {
            this.output("\t");
            this.output(copy);
            this.output(" temp = ");
        } else {
            this.generateFunctionCallLeftSide(method, returnType, needsReturn);
        }
        int paramStart = 0;
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        boolean objc_struct = false;
        if (name.equals("objc_msgSend_stret") || name.equals("objc_msgSendSuper_stret")) {
            objc_struct = true;
        }
        if (objc_struct) {
            this.outputln("if (STRUCT_SIZE_LIMIT == 0) {");
            this.output("\t\t");
        }
        if (name.equalsIgnoreCase("call") || name.startsWith("callFunc")) {
            this.output("(");
            String cast = params[0].getCast();
            if (cast.length() != 0 && !cast.equals("()")) {
                this.output(cast);
            } else {
                this.output("(");
                this.output(returnType.getTypeSignature2());
                this.output(" (");
                this.output((String)method.getParam("convention"));
                this.output("*)())");
            }
            this.output("arg0)");
            paramStart = 1;
        } else if (name.startsWith("VtblCall") || name.startsWith("_VtblCall")) {
            this.output("((");
            this.output(returnType.getTypeSignature2());
            this.output(" (STDMETHODCALLTYPE *)(");
            int i = 1;
            while (i < params.length) {
                if (i != 1) {
                    this.output(", ");
                }
                JNIParameter param = params[i];
                JNIType paramType = param.getType();
                this.output(paramType.getTypeSignature4(param.getFlag("struct")));
                ++i;
            }
            this.output("))(*(");
            JNIType paramType = params[1].getType();
            this.output(paramType.getTypeSignature4(false));
            this.output(" **)arg1)[arg0])");
            paramStart = 1;
        } else if (method.getFlag("cpp") || method.getFlag("setter") || method.getFlag("getter") || method.getFlag("adder")) {
            String cast;
            if (method.getFlag("object")) {
                this.output("TO_HANDLE(");
            }
            this.output("(");
            JNIParameter param = params[0];
            if (param.getFlag("struct")) {
                this.output("*");
            }
            if ((cast = param.getCast()).length() != 0 && !cast.equals("()")) {
                this.output(cast);
            }
            if (param.getFlag("object")) {
                this.output("TO_OBJECT(");
            }
            this.output("arg0");
            if (param.getFlag("object")) {
                this.output(")");
            }
            this.output(")->");
            String accessor = method.getAccessor();
            if (accessor.length() != 0) {
                this.output(accessor);
            } else {
                int index = -1;
                index = name.indexOf(95);
                if (index != -1) {
                    this.output(name.substring(index + 1, name.length()));
                } else {
                    this.output(name);
                }
            }
            paramStart = 1;
        } else if (method.getFlag("gcnew")) {
            this.output("TO_HANDLE(gcnew ");
            String accessor = method.getAccessor();
            if (accessor.length() != 0) {
                this.output(accessor);
            } else {
                int index = -1;
                index = name.indexOf(95);
                if (index != -1) {
                    this.output(name.substring(index + 1));
                } else {
                    this.output(name);
                }
            }
        } else if (method.getFlag("new")) {
            if (method.getFlag("object")) {
                this.output("TO_HANDLE(");
            }
            this.output("new ");
            String accessor = method.getAccessor();
            if (accessor.length() != 0) {
                this.output(accessor);
            } else {
                int index = -1;
                index = name.indexOf(95);
                if (index != -1) {
                    this.output(name.substring(0, index));
                } else {
                    this.output(name);
                }
            }
        } else {
            String accessor;
            if (method.getFlag("delete")) {
                this.output("delete ");
                JNIParameter param = params[0];
                String cast = param.getCast();
                if (cast.length() != 0 && !cast.equals("()")) {
                    this.output(cast);
                } else {
                    this.output("(");
                    this.output(name.substring(0, name.indexOf(95)));
                    this.output(" *)");
                }
                this.outputln("arg0;");
                return;
            }
            if (method.getFlag("object")) {
                this.output("TO_HANDLE(");
            }
            if (method.getFlag("cast")) {
                this.output("((");
                String returnCast = returnType.getTypeSignature2();
                if (name.equals("objc_msgSend_bool") && returnCast.equals("jboolean")) {
                    returnCast = "BOOL";
                }
                this.output(returnCast);
                this.output(" (*)(");
                int i = 0;
                while (i < params.length) {
                    JNIParameter param;
                    String cast;
                    if (i != 0) {
                        this.output(", ");
                    }
                    if ((cast = (param = params[i]).getCast()) != null && cast.length() != 0) {
                        if (cast.startsWith("(")) {
                            cast = cast.substring(1);
                        }
                        if (cast.endsWith(")")) {
                            cast = cast.substring(0, cast.length() - 1);
                        }
                        this.output(cast);
                    } else {
                        JNIType paramType = param.getType();
                        if (!paramType.isPrimitive() && !paramType.isArray() && param.getTypeClass().getFlag("struct")) {
                            this.output("struct ");
                        }
                        this.output(paramType.getTypeSignature4(param.getFlag("struct")));
                    }
                    ++i;
                }
                this.output("))");
            }
            if ((accessor = method.getAccessor()).length() != 0) {
                this.output(accessor);
            } else {
                this.output(name);
            }
            if (method.getFlag("cast")) {
                this.output(")");
            }
        }
        if (method.getFlag("setter") && params.length == 3 || method.getFlag("getter") && params.length == 2) {
            this.output("[arg1]");
            ++paramStart;
        }
        if (method.getFlag("setter")) {
            this.output(" = ");
        }
        if (method.getFlag("adder")) {
            this.output(" += ");
        }
        if (!method.getFlag("getter")) {
            this.generateFunctionCallRightSide(method, params, paramStart);
        }
        if (method.getFlag("gcnew") || method.getFlag("object")) {
            this.output(")");
        }
        this.output(";");
        this.outputln();
        if (makeCopy) {
            this.outputln("\t{");
            this.output("\t\t");
            this.output(copy);
            this.output("* copy = new ");
            this.output(copy);
            this.outputln("();");
            this.outputln("\t\t*copy = temp;");
            this.output("\t\trc = ");
            this.output("(");
            this.output(returnType.getTypeSignature2());
            this.output(")");
            this.outputln("copy;");
            this.outputln("\t}");
        }
        if (objc_struct) {
            this.outputln("\t} else if (sizeof(_arg0) > STRUCT_SIZE_LIMIT) {");
            this.generate_objc_msgSend_stret(params, name);
            this.generateFunctionCallRightSide(method, params, 1);
            this.outputln(";");
            this.outputln("\t} else {");
            this.generate_objc_msgSend_stret(params, name.substring(0, name.length() - "_stret".length()));
            this.generateFunctionCallRightSide(method, params, 1);
            this.outputln(";");
            this.outputln("\t}");
        }
    }

    void generate_objc_msgSend_stret(JNIParameter[] params, String func) {
        this.output("\t\t*lparg0 = (*(");
        JNIType paramType = params[0].getType();
        this.output(paramType.getTypeSignature4(true));
        this.output(" (*)(");
        int i = 1;
        while (i < params.length) {
            JNIParameter param;
            String cast;
            if (i != 1) {
                this.output(", ");
            }
            if ((cast = (param = params[i]).getCast()) != null && cast.length() != 0) {
                if (cast.startsWith("(")) {
                    cast = cast.substring(1);
                }
                if (cast.endsWith(")")) {
                    cast = cast.substring(0, cast.length() - 1);
                }
                this.output(cast);
            } else {
                paramType = param.getType();
                if (!paramType.isPrimitive() && !paramType.isArray() && param.getTypeClass().getFlag("struct")) {
                    this.output("struct ");
                }
                this.output(paramType.getTypeSignature4(param.getFlag("struct")));
            }
            ++i;
        }
        this.output("))");
        this.output(func);
        this.output(")");
    }

    void generateReturn(JNIType returnType, boolean needsReturn) {
        if (needsReturn && !returnType.isType("void")) {
            this.outputln("\treturn rc;");
        }
    }

    void generateMemmove(JNIMethod method, String function, JNIParameter[] params) {
        this.generateEnterExitMacro(method, function, true);
        this.output("\t");
        boolean get = params[0].getType().isPrimitive();
        String className = params[get ? 1 : 0].getType().getSimpleName();
        this.output(get ? "if (arg1) get" : "if (arg0) set");
        this.output(className);
        this.output(get ? "Fields(env, arg1, (" : "Fields(env, arg0, (");
        this.output(className);
        this.output(get ? " *)arg0)" : " *)arg1)");
        this.outputln(";");
        this.generateEnterExitMacro(method, function, false);
    }

    void generateFunctionBody(JNIMethod method, String function, JNIParameter[] params, JNIType returnType) {
        boolean isMemove;
        this.outputln("{");
        String name = method.getName();
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        boolean bl = isMemove = (name.equals("memmove") || name.equals("MoveMemory")) && params.length == 2 && returnType.isType("void");
        if (isMemove) {
            this.generateMemmove(method, function, params);
        } else {
            boolean needsReturn = this.generateLocalVars(params, returnType);
            this.generateEnterExitMacro(method, function, true);
            boolean genFailTag = this.generateGetters(params);
            if (method.getFlag("dynamic")) {
                this.generateDynamicFunctionCall(method, params, returnType, needsReturn);
            } else {
                this.generateFunctionCall(method, params, returnType, needsReturn);
            }
            if (genFailTag) {
                this.outputln("fail:");
            }
            this.generateSetters(params);
            this.generateEnterExitMacro(method, function, false);
            this.generateReturn(returnType, needsReturn);
        }
        this.outputln("}");
    }

    void generateFunctionPrototype(JNIMethod method, String function, JNIParameter[] params, JNIType returnType, boolean singleLine) {
        this.output("JNIEXPORT ");
        this.output(returnType.getTypeSignature2());
        this.output(" JNICALL ");
        this.output(method.getDeclaringClass().getSimpleName());
        this.output("_NATIVE(");
        this.output(function);
        if (singleLine) {
            this.output(")");
            this.output("(JNIEnv *env, ");
        } else {
            this.outputln(")");
            this.output("\t(JNIEnv *env, ");
        }
        if ((method.getModifiers() & 8) != 0) {
            this.output("jclass");
        } else {
            this.output("jobject");
        }
        this.output(" that");
        int i = 0;
        while (i < params.length) {
            this.output(", ");
            JNIType paramType = params[i].getType();
            this.output(paramType.getTypeSignature2());
            this.output(" arg" + i);
            ++i;
        }
        this.output(")");
        if (!singleLine) {
            this.outputln();
        }
    }

    void generateSourceStart(String function) {
        this.output("#ifndef NO_");
        this.outputln(function);
    }

    void generateSourceEnd() {
        this.outputln("#endif");
    }

    void generateIgnoreDeprecationsStart(JNIMethod method) {
        if (method.getFlag("ignore_deprecations")) {
            this.outputln("G_GNUC_BEGIN_IGNORE_DEPRECATIONS");
        }
    }

    void generateIgnoreDeprecationsEnd(JNIMethod method) {
        if (method.getFlag("ignore_deprecations")) {
            this.outputln("G_GNUC_END_IGNORE_DEPRECATIONS");
        }
    }

    boolean isCritical(JNIParameter param) {
        JNIType paramType = param.getType();
        return paramType.isArray() && paramType.getComponentType().isPrimitive() && param.getFlag("critical");
    }

    boolean isSystemClass(JNIType type) {
        return type.isType("java.lang.Object") || type.isType("java.lang.Class");
    }
}

