/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.bcoview.views;

import org.eclipse.jdt.bcoview.BytecodeOutlinePlugin;
import org.eclipse.jdt.bcoview.ui.actions.DefaultToggleAction;
import org.eclipse.jdt.bcoview.views.HelpUtils;
import org.eclipse.jdt.bcoview.views.IBytecodePart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class BytecodeReferenceView
extends ViewPart
implements IPartListener2,
ISelectionListener {
    private static final String VIEW_ID = "org.eclipse.jdt.bcoview.views.BytecodeOutlineView";
    private Browser browser;
    private DefaultToggleAction linkWithViewAction;
    private boolean linkWithView;

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 2048);
        final IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
        this.linkWithView = BytecodeOutlinePlugin.getDefault().getPreferenceStore().getBoolean("linkRefViewToEditor");
        this.linkWithViewAction = new DefaultToggleAction("linkRefViewToEditor"){

            @Override
            public void run(boolean newState) {
                BytecodeReferenceView.this.linkWithView = newState;
                if (BytecodeReferenceView.this.linkWithView) {
                    ISelectionService selectionService = workbenchWindow.getSelectionService();
                    try {
                        IViewPart part = workbenchWindow.getActivePage().showView(BytecodeReferenceView.VIEW_ID);
                        ISelection selection = selectionService.getSelection(BytecodeReferenceView.VIEW_ID);
                        BytecodeReferenceView.this.selectionChanged((IWorkbenchPart)part, selection);
                    }
                    catch (PartInitException e) {
                        BytecodeOutlinePlugin.log(e, 4);
                    }
                }
            }
        };
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tmanager = bars.getToolBarManager();
        tmanager.add((IAction)this.linkWithViewAction);
        this.shouDefaultEmptyPage();
        workbenchWindow.getPartService().addPartListener((IPartListener2)this);
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this);
        this.browser.dispose();
        this.browser = null;
        this.linkWithViewAction = null;
        super.dispose();
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        this.partVisible(partRef);
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        if (partRef.getId().equals(this.getSite().getId())) {
            this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (partRef.getId().equals(this.getSite().getId())) {
            IViewReference viewReference;
            IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
            ISelectionService selectionService = workbenchWindow.getSelectionService();
            selectionService.addPostSelectionListener((ISelectionListener)this);
            ISelection selection = selectionService.getSelection(VIEW_ID);
            if (selection != null && (viewReference = workbenchWindow.getActivePage().findViewReference(VIEW_ID)) != null) {
                this.selectionChanged((IWorkbenchPart)viewReference.getView(false), selection);
            }
        }
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection sselection;
        int size;
        boolean isBytecodePartSelection = part instanceof IBytecodePart;
        if (!this.linkWithView || !isBytecodePartSelection) {
            return;
        }
        int line = -1;
        if (selection instanceof ITextSelection) {
            line = ((ITextSelection)selection).getStartLine();
        } else if (selection instanceof IStructuredSelection && (size = (sselection = (IStructuredSelection)selection).size()) == 1 && sselection.getFirstElement() instanceof Integer) {
            line = (Integer)sselection.getFirstElement();
        }
        if (line < 0) {
            this.shouDefaultEmptyPage();
            return;
        }
        int opcode = ((IBytecodePart)part).getBytecodeInstructionAtLine(line);
        StringBuilder helpFor = HelpUtils.getOpcodeHelpFor(opcode);
        if (helpFor.length() > 0) {
            this.browser.setText(helpFor.toString());
        } else {
            this.shouDefaultEmptyPage();
        }
    }

    private void shouDefaultEmptyPage() {
        this.browser.setUrl(HelpUtils.SPECS_HTML);
    }
}

