/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.property.list.IListProperty;

public class VirtualEntry<P, E> {
    private final String id;
    private final P originalParent;
    private final String label;
    private final IObservableList<E> list;
    private final IListProperty<? super P, E> property;

    public VirtualEntry(String id, IListProperty<? super P, E> property, P originalParent, String label) {
        this.id = id;
        this.originalParent = originalParent;
        this.label = label;
        this.property = property;
        this.list = new WritableList();
        IObservableList origList = property.observe(originalParent);
        this.list.addAll(this.cleanedList(origList));
        IListChangeListener listener = event -> {
            if (!this.list.isDisposed()) {
                List<E> clean = this.cleanedList(event.getObservableList());
                ListDiff diff = Diffs.computeListDiff(this.list, clean);
                diff.applyTo(this.list);
            }
        };
        origList.addListChangeListener(listener);
    }

    public IListProperty<? super P, E> getProperty() {
        return this.property;
    }

    private List<E> cleanedList(IObservableList<? extends E> list) {
        ArrayList l = new ArrayList(list.size());
        for (Object o : list) {
            if (!this.accepted(o)) continue;
            l.add(o);
        }
        return l;
    }

    protected boolean accepted(E o) {
        return true;
    }

    public IObservableList<E> getList() {
        return this.list;
    }

    public P getOriginalParent() {
        return this.originalParent;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.label;
    }
}

