/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text.hover;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.BrowserInformationControl;
import org.eclipse.dltk.internal.ui.text.HTMLPrinter;
import org.eclipse.dltk.internal.ui.text.HTMLTextPresenter;
import org.eclipse.dltk.internal.ui.text.IInformationControlExtension4;
import org.eclipse.dltk.internal.ui.text.hover.AbstractScriptEditorTextHover;
import org.eclipse.dltk.internal.ui.text.hover.ScriptHoverMessages;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.documentation.ScriptDocumentationAccess;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public class DocumentationHover
extends AbstractScriptEditorTextHover
implements IInformationProviderExtension2,
ITextHoverExtension {
    private final long LABEL_FLAGS = 281474978840663L;
    private final long LOCAL_VARIABLE_FLAGS = 281474978971735L;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell parent) {
                    int shellStyle = 20;
                    int style = 768;
                    if (BrowserInformationControl.isAvailable((Composite)parent)) {
                        return new BrowserInformationControl(parent, shellStyle, style);
                    }
                    return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
                }
            };
        }
        return this.fPresenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell parent) {
                    if (BrowserInformationControl.isAvailable((Composite)parent)) {
                        return new BrowserInformationControl(parent, 12, 0, EditorsUI.getTooltipAffordanceString());
                    }
                    return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), EditorsUI.getTooltipAffordanceString());
                }

                public boolean canReuse(IInformationControl control) {
                    boolean canReuse = super.canReuse(control);
                    if (canReuse && control instanceof IInformationControlExtension4) {
                        ((IInformationControlExtension4)control).setStatusText(EditorsUI.getTooltipAffordanceString());
                    }
                    return canReuse;
                }
            };
        }
        return this.fHoverControlCreator;
    }

    protected String getHoverInfo(String nature, IModelElement[] result) {
        StringBuffer buffer = new StringBuffer();
        int nResults = result.length;
        if (nResults == 0) {
            return null;
        }
        boolean hasContents = false;
        if (nResults > 1) {
            HTMLPrinter.addSmallHeader(buffer, this.getInfoText(result[0]));
            HTMLPrinter.addParagraph(buffer, "<hr>");
            int i = 0;
            while (i < result.length) {
                block17: {
                    IModelElement curr = result[i];
                    if (curr instanceof IMember) {
                        Reader reader;
                        block16: {
                            IMember member = (IMember)curr;
                            try {
                                reader = ScriptDocumentationAccess.getHTMLContentReader(nature, member, true, true);
                                if (reader != null) break block16;
                                break block17;
                            }
                            catch (ModelException modelException) {
                                return null;
                            }
                        }
                        if (reader != null) {
                            if (hasContents) {
                                HTMLPrinter.addParagraph(buffer, "<hr>");
                            }
                            HTMLPrinter.addParagraph(buffer, reader);
                        }
                        hasContents = true;
                    }
                }
                ++i;
            }
        } else {
            IModelElement curr = result[0];
            if (curr instanceof IMember) {
                Reader reader;
                IMember member = (IMember)curr;
                HTMLPrinter.addSmallHeader(buffer, this.getInfoText((IModelElement)member));
                try {
                    reader = ScriptDocumentationAccess.getHTMLContentReader(nature, member, true, true);
                    if (reader == null) {
                        reader = new StringReader(ScriptHoverMessages.ScriptdocHover_noAttachedInformation);
                    }
                }
                catch (ModelException modelException) {
                    return null;
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph(buffer, reader);
                }
                hasContents = true;
            }
        }
        if (!hasContents) {
            return null;
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog(buffer, 0, DocumentationHover.getStyleSheet());
            HTMLPrinter.addPageEpilog(buffer);
            return buffer.toString();
        }
        return null;
    }

    protected String getHoverInfo(String nature, String content) {
        StringBuffer buffer = new StringBuffer();
        try {
            Reader reader = ScriptDocumentationAccess.getHTMLContentReader(nature, content);
            if (reader != null) {
                HTMLPrinter.addParagraph(buffer, reader);
                if (buffer.length() > 0) {
                    HTMLPrinter.insertPageProlog(buffer, 0, DocumentationHover.getStyleSheet());
                    HTMLPrinter.addPageEpilog(buffer);
                    return buffer.toString();
                }
            }
        }
        catch (ModelException modelException) {}
        return null;
    }

    private String getInfoText(IModelElement member) {
        long flags = member.getElementType() == 8 ? 281474978971735L : 281474978840663L;
        String label = ScriptElementLabels.getDefault().getElementLabel(member, flags);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < label.length()) {
            char ch = label.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
            } else if (ch == '>') {
                buf.append("&gt;");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }
}

