/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.dltk.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.dltk.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.dltk.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.dltk.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.dltk.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

public final class ScriptRefactoringDescriptorComment {
    private static final String ELEMENT_DELIMITER = RefactoringCoreMessages.ScriptRefactoringDescriptorComment_element_delimiter;
    private static final String LINE_DELIMITER = System.getProperty("line.separator", "\n");
    private final String fHeader;
    private final List fSettings = new ArrayList(6);

    public static String createCompositeSetting(String caption, String[] settings) {
        Assert.isNotNull((Object)caption);
        Assert.isNotNull((Object)settings);
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(caption);
        int index = 0;
        while (index < settings.length) {
            if (settings[index] != null && !"".equals(settings[index])) {
                buffer.append(LINE_DELIMITER);
                buffer.append(ELEMENT_DELIMITER);
                buffer.append(settings[index]);
            } else {
                buffer.append(LINE_DELIMITER);
                buffer.append(ELEMENT_DELIMITER);
                buffer.append(RefactoringCoreMessages.ScriptRefactoringDescriptor_not_available);
            }
            ++index;
        }
        return buffer.toString();
    }

    public ScriptRefactoringDescriptorComment(Object object, String header) {
        Assert.isNotNull((Object)object);
        Assert.isNotNull((Object)header);
        this.fHeader = header;
        this.initializeInferredSettings(object);
    }

    public void addSetting(int index, String setting) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)setting);
        Assert.isTrue((!"".equals(setting) ? 1 : 0) != 0);
        this.fSettings.add(index, setting);
    }

    public void addSetting(String setting) {
        Assert.isNotNull((Object)setting);
        Assert.isTrue((!"".equals(setting) ? 1 : 0) != 0);
        this.fSettings.add(setting);
    }

    public String asString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.fHeader);
        for (String setting : this.fSettings) {
            buffer.append(LINE_DELIMITER);
            buffer.append(MessageFormat.format(RefactoringCoreMessages.ScriptRefactoringDescriptor_inferred_setting_pattern, setting));
        }
        return buffer.toString();
    }

    public int getCount() {
        return this.fSettings.size();
    }

    private void initializeInferredSettings(Object object) {
        RefactoringProcessor processor;
        Object[] elements;
        Object updating;
        if (object instanceof INameUpdating) {
            updating = (INameUpdating)object;
            this.fSettings.add(MessageFormat.format(RefactoringCoreMessages.ScriptRefactoringDescriptor_original_element_pattern, ScriptElementLabels.getDefault().getTextLabel(updating.getElements()[0], ScriptElementLabels.ALL_FULLY_QUALIFIED)));
            try {
                Object element = updating.getNewElement();
                if (element != null) {
                    this.fSettings.add(MessageFormat.format(RefactoringCoreMessages.ScriptRefactoringDescriptor_renamed_element_pattern, ScriptElementLabels.getDefault().getTextLabel(element, ScriptElementLabels.ALL_FULLY_QUALIFIED)));
                } else {
                    String oldLabel = ScriptElementLabels.getDefault().getTextLabel(updating.getElements()[0], ScriptElementLabels.ALL_FULLY_QUALIFIED);
                    String newName = updating.getCurrentElementName();
                    if (newName.length() < oldLabel.length()) {
                        String newLabel = oldLabel.substring(0, oldLabel.length() - newName.length());
                        this.fSettings.add(MessageFormat.format(RefactoringCoreMessages.ScriptRefactoringDescriptor_renamed_element_pattern, String.valueOf(newLabel) + updating.getNewElementName()));
                    }
                }
            }
            catch (CoreException exception) {
                DLTKUIPlugin.log(exception);
            }
        } else if (object instanceof RefactoringProcessor && (elements = (processor = (RefactoringProcessor)object).getElements()) != null) {
            if (elements.length == 1 && elements[0] != null) {
                this.fSettings.add(MessageFormat.format(RefactoringCoreMessages.ScriptRefactoringDescriptor_original_element_pattern, ScriptElementLabels.getDefault().getTextLabel(elements[0], ScriptElementLabels.ALL_FULLY_QUALIFIED)));
            } else if (elements.length > 1) {
                StringBuilder buffer = new StringBuilder(128);
                buffer.append(RefactoringCoreMessages.ScriptRefactoringDescriptor_original_elements);
                int index = 0;
                while (index < elements.length) {
                    if (elements[index] != null) {
                        buffer.append(LINE_DELIMITER);
                        buffer.append(ELEMENT_DELIMITER);
                        buffer.append(ScriptElementLabels.getDefault().getTextLabel(elements[index], ScriptElementLabels.ALL_FULLY_QUALIFIED));
                    } else {
                        buffer.append(LINE_DELIMITER);
                        buffer.append(ELEMENT_DELIMITER);
                        buffer.append(RefactoringCoreMessages.ScriptRefactoringDescriptor_not_available);
                    }
                    ++index;
                }
                this.fSettings.add(buffer.toString());
            }
        }
        if (object instanceof IReferenceUpdating && (updating = (IReferenceUpdating)object).canEnableUpdateReferences() && updating.getUpdateReferences()) {
            this.fSettings.add(RefactoringCoreMessages.ScriptRefactoringDescriptor_update_references);
        }
        if (object instanceof ISimilarDeclarationUpdating && (updating = (ISimilarDeclarationUpdating)object).canEnableSimilarDeclarationUpdating() && updating.getUpdateSimilarDeclarations()) {
            int strategy = updating.getMatchStrategy();
            if (strategy == 1) {
                this.fSettings.add(RefactoringCoreMessages.ScriptRefactoringDescriptor_rename_similar);
            } else if (strategy == 2) {
                this.fSettings.add(RefactoringCoreMessages.ScriptRefactoringDescriptor_rename_similar_embedded);
            } else if (strategy == 3) {
                this.fSettings.add(RefactoringCoreMessages.ScriptRefactoringDescriptor_rename_similar_suffix);
            }
        }
        if (object instanceof IQualifiedNameUpdating && (updating = (IQualifiedNameUpdating)object).canEnableQualifiedNameUpdating() && updating.getUpdateQualifiedNames()) {
            String patterns = updating.getFilePatterns();
            if (patterns != null && !"".equals(patterns)) {
                this.fSettings.add(MessageFormat.format(RefactoringCoreMessages.ScriptRefactoringDescriptor_qualified_names_pattern, patterns.trim()));
            } else {
                this.fSettings.add(RefactoringCoreMessages.ScriptRefactoringDescriptor_qualified_names);
            }
        }
        if (object instanceof ITextUpdating && (updating = (ITextUpdating)object).canEnableTextUpdating()) {
            this.fSettings.add(RefactoringCoreMessages.ScriptRefactoringDescriptor_textual_occurrences);
        }
        if (object instanceof IDelegateUpdating && (updating = (IDelegateUpdating)object).canEnableDelegateUpdating() && updating.getDelegateUpdating()) {
            if (updating.getDeprecateDelegates()) {
                this.fSettings.add(RefactoringCoreMessages.ScriptRefactoringDescriptor_keep_original_deprecated);
            } else {
                this.fSettings.add(RefactoringCoreMessages.ScriptRefactoringDescriptor_keep_original);
            }
        }
    }

    public void removeSetting(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0);
        this.fSettings.remove(index);
    }
}

