/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementMemento;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IModelElementVisitorExtension;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.dltk.utils.CorePrinter;

public abstract class ModelElement
extends PlatformObject
implements IModelElement,
IModelElementMemento {
    public static final char JEM_ESCAPE = '\\';
    public static final char JEM_SCRIPTPROJECT = '=';
    public static final char JEM_PROJECTFRAGMENT = '/';
    public static final char JEM_SCRIPTFOLDER = '<';
    public static final char JEM_FIELD = '^';
    public static final char JEM_METHOD = '~';
    public static final char JEM_SOURCEMODULE = '{';
    public static final char JEM_TYPE = '[';
    public static final char JEM_IMPORTDECLARATION = '&';
    public static final char JEM_COUNT = '!';
    public static final char JEM_LOCALVARIABLE = '@';
    public static final char JEM_TYPE_PARAMETER = ']';
    public static final char JEM_PACKAGEDECLARATION = '%';
    public static final char JEM_USER_ELEMENT = '}';
    public static final String JEM_USER_ELEMENT_ENDING = "=/<^~{[&!@]%}";
    public static final char JEM_SKIP_DELIMETER = '>';
    protected final ModelElement parent;
    protected static final ModelElement[] NO_ELEMENTS = new ModelElement[0];
    protected static final Object NO_INFO = new Object();

    protected ModelElement(ModelElement parent) throws IllegalArgumentException {
        this.parent = parent;
    }

    @Override
    public boolean exists() {
        try {
            this.getElementInfo();
            return true;
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public IModelElement getAncestor(int ancestorType) {
        IModelElement element = this;
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Override
    public <E extends IModelElement> E getAncestor(Class<E> elementClass) {
        IModelElement element = this;
        do {
            if (!elementClass.isInstance(element)) continue;
            return (E)element;
        } while ((element = element.getParent()) != null);
        return null;
    }

    public void close() throws ModelException {
        ModelManager.getModelManager().removeInfoAndChildren(this);
    }

    protected abstract void closing(Object var1) throws ModelException;

    public Object getElementInfo() throws ModelException {
        return this.getElementInfo(null);
    }

    public Object getElementInfo(IProgressMonitor monitor) throws ModelException {
        ModelManager manager = ModelManager.getModelManager();
        Object info = manager.getInfo(this);
        if (info != null) {
            return info;
        }
        return this.openWhenClosed(this.createElementInfo(), monitor);
    }

    protected Object openWhenClosed(Object info, IProgressMonitor monitor) throws ModelException {
        ModelManager manager = ModelManager.getModelManager();
        boolean hadTemporaryCache = manager.hasTemporaryCache();
        try {
            HashMap newElements = manager.getTemporaryCache();
            this.generateInfos(info, newElements, monitor);
            if (info == null) {
                info = newElements.get(this);
            }
            if (info == null) {
                Openable openable = (Openable)this.getOpenable();
                if (newElements.containsKey(openable)) {
                    openable.closeBuffer();
                }
                throw this.newNotPresentException();
            }
            if (!hadTemporaryCache) {
                manager.putInfos(this, newElements);
            }
        }
        finally {
            if (!hadTemporaryCache) {
                manager.resetTemporaryCache();
            }
        }
        return info;
    }

    @Override
    public IOpenable getOpenable() {
        return this.getOpenableParent();
    }

    public IOpenable getOpenableParent() {
        return (IOpenable)((Object)this.parent);
    }

    @Override
    public IModelElement getParent() {
        return this.parent;
    }

    protected abstract Object createElementInfo();

    protected abstract void generateInfos(Object var1, HashMap var2, IProgressMonitor var3) throws ModelException;

    @Override
    public String getElementName() {
        return "";
    }

    public ModelException newNotPresentException() {
        return new ModelException(new ModelStatus(969, this));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.parent == null) {
            return super.equals(o);
        }
        if (o == null) {
            return false;
        }
        ModelElement other = (ModelElement)o;
        return this.getElementName().equals(other.getElementName()) && this.parent.equals(other.parent);
    }

    public int hashCode() {
        if (this.parent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.getElementName().hashCode(), this.parent.hashCode());
    }

    public boolean isAncestorOf(IModelElement e) {
        IModelElement parentElement = e.getParent();
        while (parentElement != null && !parentElement.equals(this)) {
            parentElement = parentElement.getParent();
        }
        return parentElement != null;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    protected List<IModelElement> getChildrenOfType(int type) throws ModelException {
        return this.getChildrenOfType(type, null);
    }

    protected List<IModelElement> getChildrenOfType(int type, IProgressMonitor monitor) throws ModelException {
        IModelElement[] children = this.getChildren(monitor);
        int size = children.length;
        ArrayList<IModelElement> list = new ArrayList<IModelElement>(size);
        int i = 0;
        while (i < size) {
            IModelElement elt = children[i];
            if (elt.getElementType() == type) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    public IModelElement[] getChildren() throws ModelException {
        return this.getChildren(null);
    }

    public IModelElement[] getChildren(IProgressMonitor monitor) throws ModelException {
        Object elementInfo = this.getElementInfo(monitor);
        if (elementInfo instanceof ModelElementInfo) {
            return ((ModelElementInfo)elementInfo).getChildren();
        }
        return NO_ELEMENTS;
    }

    @Override
    public IScriptModel getModel() {
        IModelElement current = this;
        do {
            if (!(current instanceof IScriptModel)) continue;
            return (IScriptModel)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public ModelException newModelException(IStatus status) {
        if (status instanceof IModelStatus) {
            return new ModelException((IModelStatus)status);
        }
        return new ModelException(new ModelStatus(status.getSeverity(), status.getCode(), status.getMessage()));
    }

    @Override
    public IScriptProject getScriptProject() {
        IModelElement current = this;
        do {
            if (!(current instanceof IScriptProject)) continue;
            return (IScriptProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public boolean hasChildren() throws ModelException {
        Object elementInfo = ModelManager.getModelManager().getInfo(this);
        if (elementInfo instanceof ModelElementInfo) {
            return ((ModelElementInfo)elementInfo).getChildren().length > 0;
        }
        return true;
    }

    protected String tabString(int tab) {
        StringBuilder buffer = new StringBuilder();
        int i = tab;
        while (i > 0) {
            buffer.append("  ");
            --i;
        }
        return buffer.toString();
    }

    public String toDebugString() {
        StringBuilder buffer = new StringBuilder();
        this.toStringInfo(0, buffer, NO_INFO, true);
        return buffer.toString();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(0, buffer);
        return buffer.toString();
    }

    protected void toString(int tab, StringBuilder buffer) {
        Object info = this.toStringInfo(tab, buffer);
        if (tab == 0) {
            this.toStringAncestors(buffer);
        }
        this.toStringChildren(tab, buffer, info);
    }

    public String toStringWithAncestors() {
        return this.toStringWithAncestors(true);
    }

    public String toStringWithAncestors(boolean showResolvedInfo) {
        StringBuilder buffer = new StringBuilder();
        this.toStringInfo(0, buffer, NO_INFO, showResolvedInfo);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }

    protected void toStringAncestors(StringBuilder buffer) {
        ModelElement parentElement = (ModelElement)this.getParent();
        if (parentElement != null && parentElement.getParent() != null) {
            buffer.append(" [in ");
            parentElement.toStringInfo(0, buffer, NO_INFO, false);
            parentElement.toStringAncestors(buffer);
            buffer.append("]");
        }
    }

    protected void toStringChildren(int tab, StringBuilder buffer, Object info) {
        if (info == null || !(info instanceof ModelElementInfo)) {
            return;
        }
        IModelElement[] children = ((ModelElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            buffer.append("\n");
            ((ModelElement)children[i]).toString(tab + 1, buffer);
            ++i;
        }
    }

    public Object toStringInfo(int tab, StringBuilder buffer) {
        Object info = ModelManager.getModelManager().peekAtInfo(this);
        this.toStringInfo(tab, buffer, info, true);
        return info;
    }

    protected void toStringInfo(int tab, StringBuilder buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        this.toStringName(buffer);
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    protected void toStringName(StringBuilder buffer) {
        buffer.append(this.getElementName());
    }

    protected IModelElement getSourceElementAt(int position) throws ModelException {
        IModelElement res = this.getSourceElementAtTop(position);
        if (res != this) {
            return res;
        }
        if (this instanceof ISourceReference) {
            IModelElement[] children = this.getChildren();
            int i = children.length - 1;
            while (i >= 0) {
                SourceRefElement child;
                IModelElement aChild = children[i];
                if (aChild instanceof SourceRefElement && (child = (SourceRefElement)children[i]) instanceof IParent && (res = child.getSourceElementAt(position)) != child) {
                    return res;
                }
                --i;
            }
        } else {
            Assert.isTrue((boolean)false);
        }
        return this;
    }

    protected IModelElement getSourceElementAtTop(int position) throws ModelException {
        if (this instanceof ISourceReference) {
            IModelElement[] children = this.getChildren();
            int i = children.length - 1;
            while (i >= 0) {
                IModelElement aChild = children[i];
                if (aChild instanceof SourceRefElement) {
                    SourceRefElement child = (SourceRefElement)children[i];
                    ISourceRange range = child.getSourceRange();
                    int start = range.getOffset();
                    int end = start + range.getLength();
                    if (start <= position && position <= end) {
                        if (child instanceof IField) {
                            int declarationStart = start;
                            SourceRefElement candidate = null;
                            do {
                                if (position > (range = ((IField)((Object)child)).getNameRange()).getOffset() + range.getLength()) {
                                    return candidate == null ? child.getSourceElementAt(position) : candidate.getSourceElementAt(position);
                                }
                                candidate = child;
                                SourceRefElement sourceRefElement = child = --i >= 0 ? (SourceRefElement)children[i] : null;
                            } while (child instanceof IField && child.getSourceRange().getOffset() == declarationStart);
                            return candidate.getSourceElementAt(position);
                        }
                        if (child instanceof IParent) {
                            return child.getSourceElementAt(position);
                        }
                        return child;
                    }
                }
                --i;
            }
        } else {
            Assert.isTrue((boolean)false);
        }
        return this;
    }

    protected String describeElement() {
        return String.valueOf(ScriptModelUtil.describeElementType(this.getElementType())) + ':' + this.getElementName();
    }

    public void printNode(CorePrinter output) {
        output.formatPrint(this.describeElement());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    @Override
    public IModelElement getPrimaryElement() {
        return this.getPrimaryElement(true);
    }

    public IModelElement getPrimaryElement(boolean checkOwner) {
        return this;
    }

    @Override
    public IModelElement getHandleFromMemento(MementoTokenizer memento, WorkingCopyOwner owner) {
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento, owner);
    }

    @Override
    public abstract IModelElement getHandleFromMemento(String var1, MementoTokenizer var2, WorkingCopyOwner var3);

    @Override
    public String getHandleIdentifier() {
        return this.getHandleMemento();
    }

    public String getHandleMemento() {
        StringBuilder buff = new StringBuilder();
        this.getHandleMemento(buff);
        return buff.toString();
    }

    public void getHandleMemento(StringBuilder buff) {
        ((ModelElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
    }

    protected abstract char getHandleMementoDelimiter();

    protected void escapeMementoName(StringBuilder buffer, String mementoName) {
        int i = 0;
        int length = mementoName.length();
        while (i < length) {
            char character = mementoName.charAt(i);
            switch (character) {
                case '!': 
                case '&': 
                case '/': 
                case '<': 
                case '=': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '}': 
                case '~': {
                    buffer.append('\\');
                }
            }
            buffer.append(character);
            ++i;
        }
    }

    public ISourceModule getSourceModule() {
        return null;
    }

    @Override
    public void accept(IModelElementVisitor visitor) throws ModelException {
        if (visitor.visit(this)) {
            IModelElement[] elements = this.getChildren();
            int i = 0;
            while (i < elements.length) {
                elements[i].accept(visitor);
                ++i;
            }
            if (visitor instanceof IModelElementVisitorExtension) {
                ((IModelElementVisitorExtension)visitor).endVisit(this);
            }
        }
    }
}

