/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKPriorityContributionSelector;
import org.eclipse.dltk.core.IDLTKContributedExtension;
import org.eclipse.dltk.core.IDLTKContributionSelector;

public abstract class DLTKContributionExtensionManager {
    private static final String NATURE_ID = "natureId";
    private static final String SELECTOR_TAG = "selector";
    public static final String CLASS_TAG = "class";
    private IDLTKContributionSelector defaultSelector;
    private Map natureToContribMap = new HashMap();
    private Map natureToSelectorMap = new HashMap();

    protected DLTKContributionExtensionManager() {
        this.defaultSelector = new DLTKPriorityContributionSelector();
        this.loadExtensionPoints();
    }

    public IDLTKContributedExtension[] getContributions(String natureId) {
        List contributions = this.getContributionsByNature(natureId);
        return contributions.toArray(new IDLTKContributedExtension[contributions.size()]);
    }

    public IDLTKContributedExtension getSelectedContribution(IProject project, String natureId) {
        IDLTKContributedExtension[] contributions = this.getContributions(natureId);
        if (contributions.length > 0) {
            IDLTKContributionSelector selector = this.getSelector(natureId);
            if (selector == null) {
                selector = this.defaultSelector;
            }
            return selector.select(contributions, project);
        }
        return null;
    }

    public IDLTKContributedExtension getPriorityContribution(IProject project, String natureId) {
        IDLTKContributedExtension[] contributions = this.getContributions(natureId);
        return this.defaultSelector.select(contributions, project);
    }

    protected final List getContributionsByNature(String natureId) {
        if (!this.hasContributions(natureId)) {
            return Collections.EMPTY_LIST;
        }
        return (List)this.natureToContribMap.get(natureId);
    }

    protected final IDLTKContributionSelector getSelector(String natureId) {
        return (IDLTKContributionSelector)this.natureToSelectorMap.get(natureId);
    }

    protected final boolean hasContributions(String natureId) {
        if (this.natureToContribMap.containsKey(natureId)) {
            List list = (List)this.natureToContribMap.get(natureId);
            return !list.isEmpty();
        }
        return false;
    }

    public final boolean hasSelector(String natureId) {
        return this.natureToSelectorMap.containsKey(natureId);
    }

    public final IDLTKContributedExtension getContributionById(String id) {
        Iterator keys = this.natureToContribMap.keySet().iterator();
        while (keys.hasNext()) {
            List list = (List)this.natureToContribMap.get(keys.next());
            for (IDLTKContributedExtension contrib : list) {
                if (!contrib.getId().equals(id)) continue;
                return contrib;
            }
        }
        return null;
    }

    protected abstract String getContributionElementName();

    protected abstract String getExtensionPoint();

    protected abstract boolean isValidContribution(Object var1);

    protected Object configureContribution(Object object, IConfigurationElement config) {
        return object;
    }

    protected final void addContribution(String natureId, IConfigurationElement element) {
        try {
            Object object = element.createExecutableExtension(CLASS_TAG);
            if (this.isValidContribution(object)) {
                Object contrib = this.configureContribution(object, element);
                ArrayList<Object> list = (ArrayList<Object>)this.natureToContribMap.get(natureId);
                if (list == null) {
                    list = new ArrayList<Object>();
                    this.natureToContribMap.put(natureId, list);
                }
                list.add(contrib);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected final void addSelector(String natureId, IConfigurationElement element) {
        try {
            Object object = element.createExecutableExtension(CLASS_TAG);
            if (object instanceof IDLTKContributionSelector) {
                this.natureToSelectorMap.put(natureId, object);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void loadChildren(String natureId, IConfigurationElement[] innerElements) {
        int j = 0;
        while (j < innerElements.length) {
            IConfigurationElement innerElement = innerElements[j];
            String name = innerElement.getName();
            if (name.equals(this.getContributionElementName())) {
                this.addContribution(natureId, innerElement);
            } else if (name.equals(SELECTOR_TAG)) {
                this.addSelector(natureId, innerElement);
            }
            ++j;
        }
    }

    private void loadExtensionPoints() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] extensions = registry.getExtensionPoint(this.getExtensionPoint()).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements;
            IExtension extension = extensions[i];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement main = iConfigurationElementArray[n2];
                if (this.isNatureContribution(main)) {
                    String natureId = main.getAttribute(NATURE_ID);
                    IConfigurationElement[] innerElements = main.getChildren();
                    this.loadChildren(natureId, innerElements);
                }
                ++n2;
            }
            ++i;
        }
    }

    protected boolean isNatureContribution(IConfigurationElement main) {
        return true;
    }
}

