/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast.statements;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;

public class IfStatement
extends Statement {
    private Statement fCondition;
    private Statement fThenStatement;
    private Statement fElseStatement;

    public IfStatement(DLTKToken ifToken, Statement condition, Statement thenStatement) {
        super(ifToken);
        this.fCondition = condition;
        this.fThenStatement = thenStatement;
    }

    public IfStatement(Statement condition, Statement thenStatement, Statement elseStatement) {
        this.fCondition = condition;
        this.fThenStatement = thenStatement;
        this.fElseStatement = elseStatement;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Statement)this)) {
            if (this.fCondition != null) {
                this.fCondition.traverse(pVisitor);
            }
            if (this.fThenStatement != null) {
                this.fThenStatement.traverse(pVisitor);
            }
            if (this.fElseStatement != null) {
                this.fElseStatement.traverse(pVisitor);
            }
            pVisitor.endvisit((Statement)this);
        }
    }

    public int getKind() {
        return 2005;
    }

    @Deprecated
    public void setElse(Statement elses) {
        this.acceptElse(elses);
    }

    public void acceptElse(Statement elseStatement) {
        this.fElseStatement = elseStatement;
        if (this.fElseStatement != null) {
            this.setEnd(this.fElseStatement.sourceEnd());
        }
    }

    public Statement getElse() {
        return this.fElseStatement;
    }

    public Statement getThen() {
        return this.fThenStatement;
    }

    public Statement getCondition() {
        return this.fCondition;
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("if: ");
        if (this.fCondition != null) {
            this.fCondition.printNode(output);
        }
        if (this.fThenStatement != null) {
            if (!(this.fThenStatement instanceof Block)) {
                output.indent();
            }
            this.fThenStatement.printNode(output);
            if (!(this.fThenStatement instanceof Block)) {
                output.dedent();
            }
        }
        if (this.fElseStatement != null) {
            output.formatPrintLn("else:");
            if (!(this.fElseStatement instanceof Block)) {
                output.indent();
            }
            this.fElseStatement.printNode(output);
            if (!(this.fElseStatement instanceof Block)) {
                output.dedent();
            }
        }
    }
}

