/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.core.keyword.IKeywordCategory;
import org.eclipse.dltk.javascript.core.JSKeywordCategory;
import org.eclipse.dltk.javascript.core.JSKeywordManager;
import org.eclipse.dltk.javascript.core.JavaScriptKeywords;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptWhitespaceDetector;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptWordDetector;
import org.eclipse.dltk.ui.coloring.ColoringPreferences;
import org.eclipse.dltk.ui.coloring.IKeywordColorProvider;
import org.eclipse.dltk.ui.coloring.ITextRuleProvider;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ITokenFactory;
import org.eclipse.dltk.ui.text.rules.FloatNumberRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class JavascriptCodeScanner
extends AbstractScriptScanner {
    private static final String fgReturnKeyword = "return";
    private static final String[] fgTokenProperties = new String[]{"DLTK_default", "DLTK_keyword", "DLTK_keyword_return", "DLTK_number", "DLTK_function_definition"};
    private IKeywordColorProvider[] keywordColorProviders = null;

    public JavascriptCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    private IToken getKeywordColor(String keyword, IToken defaultToken) {
        if (this.keywordColorProviders == null) {
            this.keywordColorProviders = ColoringPreferences.getKeywordColorProviders((String)"org.eclipse.dltk.javascript.core.nature");
        }
        IKeywordColorProvider[] iKeywordColorProviderArray = this.keywordColorProviders;
        int n = this.keywordColorProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IKeywordColorProvider provider = iKeywordColorProviderArray[n2];
            String colorKey = provider.getColorKey((IKeywordCategory)JSKeywordCategory.CODE, keyword);
            if (colorKey != null) {
                return this.getToken(colorKey);
            }
            ++n2;
        }
        return defaultToken;
    }

    protected List<IRule> createRules() {
        String word;
        ArrayList<IRule> rules = new ArrayList<IRule>();
        Token keyword = this.getToken("DLTK_keyword");
        Token keywordReturn = this.getToken("DLTK_keyword_return");
        Token other = this.getToken("DLTK_default");
        Token def = this.getToken("DLTK_function_definition");
        Token number = this.getToken("DLTK_number");
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new JavascriptWhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new JavascriptWordDetector(), (IToken)other);
        String[] stringArray = JavaScriptKeywords.getJavaScriptKeywords();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            wordRule.addWord(word, this.getKeywordColor(word, (IToken)keyword));
            ++n2;
        }
        stringArray = JavaScriptKeywords.getHighLightOnlyKeywords();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            wordRule.addWord(word, this.getKeywordColor(word, (IToken)keyword));
            ++n2;
        }
        wordRule.addWord(fgReturnKeyword, this.getKeywordColor(fgReturnKeyword, (IToken)keywordReturn));
        stringArray = JSKeywordManager.getInstance().getKeywords((IKeywordCategory)JSKeywordCategory.CODE, null);
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            wordRule.addWord(word, this.getKeywordColor(word, (IToken)keyword));
            ++n2;
        }
        rules.add((IRule)wordRule);
        rules.add((IRule)new FloatNumberRule((IToken)number));
        ITextRuleProvider[] textRuleProviders = ColoringPreferences.getTextRules((String)"org.eclipse.dltk.javascript.core.nature");
        if (textRuleProviders != null) {
            ITextRuleProvider[] iTextRuleProviderArray = textRuleProviders;
            int n3 = textRuleProviders.length;
            n = 0;
            while (n < n3) {
                ITextRuleProvider provider = iTextRuleProviderArray[n];
                IRule[] r = provider.getRules("__dftl_partition_content_type", (ITokenFactory)this);
                if (r != null) {
                    Collections.addAll(rules, r);
                }
                ++n;
            }
        }
        this.setDefaultReturnToken((IToken)other);
        return rules;
    }
}

