/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.sql.h2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import org.eclipse.dltk.core.index.sql.File;
import org.eclipse.dltk.core.index.sql.IFileDao;
import org.eclipse.dltk.internal.core.index.sql.h2.H2Cache;

public class H2FileDao
implements IFileDao {
    private static final String Q_INSERT = "INSERT INTO FILES(PATH,TIMESTAMP,CONTAINER_ID) VALUES(?,?,?);";
    private static final String Q_SELECT = "SELECT * FROM FILES WHERE PATH=? AND CONTAINER_ID=?;";
    private static final String Q_SELECT_BY_CONTAINER_ID = "SELECT * FROM FILES WHERE CONTAINER_ID=?;";
    private static final String Q_SELECT_BY_ID = "SELECT * FROM FILES WHERE ID=?;";
    private static final String Q_DELETE = "DELETE FROM FILES WHERE PATH=? AND CONTAINER_ID=?;";
    private static final String Q_DELETE_BY_ID = "DELETE FROM FILES WHERE ID=?;";

    /*
     * Exception decompiling
     */
    public File insert(Connection connection, String path, long timestamp, int containerId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public File select(Connection connection, String path, int containerId) throws SQLException {
        File file = H2Cache.selectFileByContainerIdAndPath(containerId, path);
        if (file == null) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (PreparedStatement statement = connection.prepareStatement(Q_SELECT);){
                int param = 0;
                statement.setString(++param, path);
                statement.setInt(++param, containerId);
                Throwable throwable2 = null;
                Object var10_13 = null;
                try (ResultSet result = statement.executeQuery();){
                    if (result.next()) {
                        file = new File(result.getInt(1), result.getString(2), result.getLong(3), result.getInt(4));
                        H2Cache.addFile(file);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        return file;
    }

    public File[] selectByContainerId(Connection connection, int containerId) throws SQLException {
        File[] files = H2Cache.selectFilesByContainerIdAsArray(containerId);
        if (files == null) {
            LinkedList<File> containerFiles = new LinkedList<File>();
            Throwable throwable = null;
            Object var6_7 = null;
            try (PreparedStatement statement = connection.prepareStatement(Q_SELECT_BY_CONTAINER_ID);){
                int param = 0;
                statement.setInt(++param, containerId);
                Throwable throwable2 = null;
                Object var10_13 = null;
                try (ResultSet result = statement.executeQuery();){
                    while (result.next()) {
                        File file = new File(result.getInt(1), result.getString(2), result.getLong(3), result.getInt(4));
                        containerFiles.add(file);
                        H2Cache.addFile(file);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            files = containerFiles.toArray(new File[containerFiles.size()]);
        }
        return files;
    }

    public File selectById(Connection connection, int id) throws SQLException {
        File file = H2Cache.selectFileById(id);
        if (file == null) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (PreparedStatement statement = connection.prepareStatement(Q_SELECT_BY_ID);){
                int param = 0;
                statement.setInt(++param, id);
                Throwable throwable2 = null;
                Object var9_12 = null;
                try (ResultSet result = statement.executeQuery();){
                    if (result.next()) {
                        file = new File(result.getInt(1), result.getString(2), result.getLong(3), result.getInt(4));
                        H2Cache.addFile(file);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        return file;
    }

    public void delete(Connection connection, String path, int containerId) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (PreparedStatement statement = connection.prepareStatement(Q_DELETE);){
            int param = 0;
            statement.setString(++param, path);
            statement.setInt(++param, containerId);
            statement.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        H2Cache.deleteFileByContainerIdAndPath(containerId, path);
    }

    public void deleteById(Connection connection, int id) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement statement = connection.prepareStatement(Q_DELETE_BY_ID);){
            int param = 0;
            statement.setInt(++param, id);
            statement.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        H2Cache.deleteFileById(id);
    }
}

