/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.formatter.internal;

import java.util.List;
import org.eclipse.dltk.tcl.ast.ComplexString;
import org.eclipse.dltk.tcl.ast.Node;
import org.eclipse.dltk.tcl.ast.Script;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.Substitution;
import org.eclipse.dltk.tcl.ast.TclArgumentList;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.ast.VariableReference;
import org.eclipse.dltk.tcl.parser.TclParserUtils;
import org.eclipse.dltk.tcl.parser.TclVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatterIndentDetector
extends TclVisitor {
    private int level;
    private final int offset;
    private boolean indentDetected;
    private int result;

    public FormatterIndentDetector(int offset) {
        this.offset = offset;
    }

    public int getLevel(List<TclCommand> commands) {
        this.level = 0;
        this.result = 0;
        this.indentDetected = false;
        TclParserUtils.traverse(commands, (TclVisitor)this);
        return this.result;
    }

    public boolean visit(Script script) {
        ++this.level;
        return this.detect((Node)script);
    }

    public void endVisit(Script script) {
        --this.level;
    }

    public boolean visit(ComplexString list) {
        return this.detect((Node)list);
    }

    public boolean visit(StringArgument arg) {
        return this.detect((Node)arg);
    }

    public boolean visit(Substitution substitution) {
        return this.detect((Node)substitution);
    }

    public boolean visit(TclArgumentList list) {
        return this.detect((Node)list);
    }

    public boolean visit(TclCommand command) {
        return this.detect((Node)command);
    }

    public boolean visit(VariableReference list) {
        return this.detect((Node)list);
    }

    private boolean detect(Node node) {
        if (!this.indentDetected && node.getStart() >= this.offset) {
            this.result = this.level;
            this.indentDetected = true;
        }
        return !this.indentDetected;
    }
}

