/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core.dom.impl;

import org.eclipse.dltk.javascript.core.dom.DomPackage;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.IProperty;
import org.eclipse.dltk.javascript.core.dom.PropertyAccessExpression;
import org.eclipse.dltk.javascript.core.dom.impl.ExpressionImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class PropertyAccessExpressionImpl
extends ExpressionImpl
implements PropertyAccessExpression {
    protected Expression object;
    protected IProperty property;

    protected PropertyAccessExpressionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return DomPackage.Literals.PROPERTY_ACCESS_EXPRESSION;
    }

    @Override
    public Expression getObject() {
        return this.object;
    }

    public NotificationChain basicSetObject(Expression newObject, NotificationChain msgs) {
        Expression oldObject = this.object;
        this.object = newObject;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldObject, (Object)newObject);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setObject(Expression newObject) {
        if (newObject != this.object) {
            NotificationChain msgs = null;
            if (this.object != null) {
                msgs = ((InternalEObject)this.object).eInverseRemove((InternalEObject)this, -3, null, msgs);
            }
            if (newObject != null) {
                msgs = ((InternalEObject)newObject).eInverseAdd((InternalEObject)this, -3, null, msgs);
            }
            if ((msgs = this.basicSetObject(newObject, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newObject, (Object)newObject));
        }
    }

    @Override
    public IProperty getProperty() {
        return this.property;
    }

    public NotificationChain basicSetProperty(IProperty newProperty, NotificationChain msgs) {
        IProperty oldProperty = this.property;
        this.property = newProperty;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldProperty, (Object)newProperty);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setProperty(IProperty newProperty) {
        if (newProperty != this.property) {
            NotificationChain msgs = null;
            if (this.property != null) {
                msgs = ((InternalEObject)this.property).eInverseRemove((InternalEObject)this, -4, null, msgs);
            }
            if (newProperty != null) {
                msgs = ((InternalEObject)newProperty).eInverseAdd((InternalEObject)this, -4, null, msgs);
            }
            if ((msgs = this.basicSetProperty(newProperty, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newProperty, (Object)newProperty));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetObject(null, msgs);
            }
            case 3: {
                return this.basicSetProperty(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getObject();
            }
            case 3: {
                return this.getProperty();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setObject((Expression)newValue);
                return;
            }
            case 3: {
                this.setProperty((IProperty)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setObject(null);
                return;
            }
            case 3: {
                this.setProperty(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.object != null;
            }
            case 3: {
                return this.property != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

