/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.compiler.problem.CategorizedProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.BufferManager;
import org.eclipse.dltk.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.internal.ui.editor.DocumentAdapter;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ExternalStorageEditorInput;
import org.eclipse.dltk.internal.ui.editor.ISavePolicy;
import org.eclipse.dltk.internal.ui.editor.ISourceModuleDocumentProvider;
import org.eclipse.dltk.internal.ui.editor.Messages;
import org.eclipse.dltk.internal.ui.editor.SourceForwardingDocumentProvider;
import org.eclipse.dltk.internal.ui.text.IProblemRequestorExtension;
import org.eclipse.dltk.internal.ui.text.spelling.ScriptSpellingProblem;
import org.eclipse.dltk.internal.ui.text.spelling.SpellingProblems;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.editor.ScriptMarkerAnnotation;
import org.eclipse.dltk.ui.editor.SourceModuleAnnotationModelEvent;
import org.eclipse.dltk.ui.editor.saveparticipant.IPostSaveListener;
import org.eclipse.dltk.ui.editor.saveparticipant.SaveParticipantRegistry;
import org.eclipse.dltk.ui.text.ScriptAnnotationUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;

public class SourceModuleDocumentProvider
extends TextFileDocumentProvider
implements ISourceModuleDocumentProvider {
    private boolean fIsAboutToSave = false;
    private static final String HANDLE_TEMPORARY_PROBLEMS = "handleTemporaryProblems";
    private ISavePolicy fSavePolicy;
    private IPropertyChangeListener fPropertyListener;
    private GlobalAnnotationModelListener fGlobalAnnotationModelListener;
    private final Map<Object, SourceModuleInfo> fFakeCUMapForMissingInfo = new HashMap<Object, SourceModuleInfo>();

    public boolean isModifiable(Object element) {
        ISourceModule module;
        if (element instanceof FileStoreEditorInput && (module = DLTKUIPlugin.resolveSourceModule((FileStoreEditorInput)element)) != null) {
            return !module.isReadOnly();
        }
        return super.isModifiable(element);
    }

    public SourceModuleDocumentProvider() {
        Object provider = new TextFileDocumentProvider();
        provider = new SourceForwardingDocumentProvider((IDocumentProvider)provider);
        this.setParentDocumentProvider((IDocumentProvider)provider);
        this.fGlobalAnnotationModelListener = new GlobalAnnotationModelListener();
        this.fPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (SourceModuleDocumentProvider.HANDLE_TEMPORARY_PROBLEMS.equals(event.getProperty())) {
                    SourceModuleDocumentProvider.this.enableHandlingTemporaryProblems();
                }
            }
        };
        DLTKUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
    }

    @Override
    public void shutdown() {
        DLTKUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyListener);
        Iterator e = this.getConnectedElementsIterator();
        while (e.hasNext()) {
            this.disconnect(e.next());
        }
    }

    @Override
    public ISourceModule getWorkingCopy(Object element) {
        TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(element);
        if (fileInfo instanceof SourceModuleInfo) {
            SourceModuleInfo info = (SourceModuleInfo)fileInfo;
            return info.fCopy;
        }
        SourceModuleInfo cuInfo = this.fFakeCUMapForMissingInfo.get(element);
        if (cuInfo != null) {
            return cuInfo.fCopy;
        }
        return null;
    }

    @Override
    public void saveDocumentContent(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (!this.fIsAboutToSave) {
            return;
        }
        super.saveDocument(monitor, element, document, overwrite);
    }

    @Override
    public ILineTracker createLineTracker(Object element) {
        return new DefaultLineTracker();
    }

    protected boolean isHandlingTemporaryProblems() {
        IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(HANDLE_TEMPORARY_PROBLEMS);
    }

    protected void enableHandlingTemporaryProblems() {
        boolean enable = this.isHandlingTemporaryProblems();
        Iterator iter = this.getFileInfosIterator();
        while (iter.hasNext()) {
            TextFileDocumentProvider.FileInfo info = (TextFileDocumentProvider.FileInfo)iter.next();
            if (!(info.fModel instanceof IProblemRequestorExtension)) continue;
            IProblemRequestorExtension extension = (IProblemRequestorExtension)info.fModel;
            extension.setIsHandlingTemporaryProblems(enable);
        }
    }

    @Override
    public void setSavePolicy(ISavePolicy savePolicy) {
        this.fSavePolicy = savePolicy;
    }

    @Override
    public void addGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.addListener(listener);
    }

    @Override
    public void removeGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.removeListener(listener);
    }

    protected ISourceModule createSourceModule(IFile file) {
        IModelElement element = DLTKCore.create((IFile)file);
        if (element instanceof ISourceModule) {
            return (ISourceModule)element;
        }
        return null;
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new SourceModuleInfo();
    }

    private void setUpSynchronization(SourceModuleInfo cuInfo) {
        IDocument document = cuInfo.fTextFileBuffer.getDocument();
        IAnnotationModel model = cuInfo.fModel;
        if (document instanceof ISynchronizable && model instanceof ISynchronizable) {
            Object lock = ((ISynchronizable)document).getLockObject();
            ((ISynchronizable)model).setLockObject(lock);
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new SourceModuleAnnotationModel((IResource)file);
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        TextFileDocumentProvider.FileInfo info;
        IModelElement modelE;
        ISourceModule original = null;
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            original = this.createSourceModule(input.getFile());
        }
        if (original == null && element instanceof IAdaptable && (modelE = (IModelElement)((IAdaptable)element).getAdapter(IModelElement.class)) != null && modelE instanceof ISourceModule) {
            original = (ISourceModule)modelE;
        }
        if (!((info = super.createFileInfo(element)) instanceof SourceModuleInfo)) {
            return null;
        }
        DelegatingRequestor delegatingRequestor = null;
        if (original == null) {
            delegatingRequestor = new DelegatingRequestor();
            original = this.createFakeSourceModule(element, false, (IProblemRequestor)delegatingRequestor);
        }
        if (original == null) {
            return null;
        }
        if (info.fModel == null) {
            IPath location = original.getPath();
            info.fModel = new ExternalSourceModuleAnnotationModel(location);
        }
        SourceModuleInfo cuInfo = (SourceModuleInfo)info;
        this.setUpSynchronization(cuInfo);
        IProblemRequestor requestor = cuInfo.getProblemRequestor();
        if (delegatingRequestor != null) {
            delegatingRequestor.fRequestor = requestor;
        }
        if (requestor instanceof IProblemRequestorExtension) {
            IProblemRequestorExtension extension = (IProblemRequestorExtension)requestor;
            extension.setIsActive(false);
            extension.setIsHandlingTemporaryProblems(this.isHandlingTemporaryProblems());
        }
        if (ScriptModelUtil.isPrimary((ISourceModule)original)) {
            original.becomeWorkingCopy(requestor, this.getProgressMonitor());
        }
        cuInfo.fCopy = original;
        if (cuInfo.fModel instanceof SourceModuleAnnotationModel) {
            SourceModuleAnnotationModel model = (SourceModuleAnnotationModel)cuInfo.fModel;
            model.setSourceModule(cuInfo.fCopy);
        }
        if (cuInfo.fModel != null) {
            cuInfo.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
        }
        return cuInfo;
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        if (info instanceof SourceModuleInfo) {
            SourceModuleInfo cuInfo = (SourceModuleInfo)info;
            try {
                cuInfo.fCopy.discardWorkingCopy();
            }
            catch (ModelException x) {
                this.handleCoreException((CoreException)((Object)x), x.getMessage());
            }
        }
        super.disposeFileInfo(element, info);
    }

    private IProgressMonitor getSubProgressMonitor(IProgressMonitor monitor, int ticks) {
        if (monitor != null) {
            return new SubProgressMonitor(monitor, ticks, 4);
        }
        return new NullProgressMonitor();
    }

    protected TextFileDocumentProvider.DocumentProviderOperation createSaveOperation(final Object element, IDocument document, final boolean overwrite) throws CoreException {
        final TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info instanceof SourceModuleInfo) {
            ISourceModule cu = ((SourceModuleInfo)info).fCopy;
            if (cu != null && !ScriptModelUtil.isPrimary((ISourceModule)cu)) {
                return super.createSaveOperation(element, document, overwrite);
            }
            if (info.fTextFileBuffer.getDocument() != document) {
                System.out.println("SourceModuleDocumentProvider: need to replace with messages api");
                Status status = new Status(2, "org.eclipse.ui.editors", 4, Messages.SourceModuleDocumentProvider_saveAsTargetOpenInEditor, null);
                throw new CoreException((IStatus)status);
            }
            return new TextFileDocumentProvider.DocumentProviderOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    SourceModuleDocumentProvider.this.commitWorkingCopy(monitor, element, (SourceModuleInfo)info, overwrite);
                }

                public ISchedulingRule getSchedulingRule() {
                    if (info.fElement instanceof IFileEditorInput) {
                        IFile file = ((IFileEditorInput)info.fElement).getFile();
                        return SourceModuleDocumentProvider.this.computeSchedulingRule((IResource)file);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void commitWorkingCopy(IProgressMonitor monitor, Object element, SourceModuleInfo info, boolean overwrite) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 100);
        try {
            IResource r;
            IMarker[] markers;
            ISourceModule unit;
            IDocument document = info.fTextFileBuffer.getDocument();
            IResource resource = info.fCopy.getResource();
            Assert.isTrue((boolean)(resource instanceof IFile));
            boolean isSynchronized = resource.isSynchronized(0);
            if (!isSynchronized && this.isDeleted(element)) {
                info.fTextFileBuffer.setDirty(true);
            }
            if (!resource.exists()) {
                this.createFileFromDocument(monitor, (IFile)resource, document);
                return;
            }
            if (this.fSavePolicy != null) {
                this.fSavePolicy.preSave(info.fCopy);
            }
            IProgressMonitor subMonitor = null;
            try {
                try {
                    IRegion[] changedRegions;
                    CoreException changedRegionException;
                    IPostSaveListener[] listeners;
                    block30: {
                        this.fIsAboutToSave = true;
                        listeners = DLTKUIPlugin.getDefault().getSaveParticipantRegistry().getEnabledPostSaveListeners(info.fCopy);
                        changedRegionException = null;
                        boolean needsChangedRegions = false;
                        try {
                            if (listeners.length > 0) {
                                needsChangedRegions = SaveParticipantRegistry.isChangedRegionsRequired(info.fCopy, listeners);
                            }
                        }
                        catch (CoreException ex) {
                            changedRegionException = ex;
                        }
                        changedRegions = null;
                        if (needsChangedRegions) {
                            try {
                                try {
                                    changedRegions = EditorUtility.calculateChangedLineRegions(info.fTextFileBuffer, this.getSubProgressMonitor(monitor, 20));
                                }
                                catch (CoreException ex) {
                                    changedRegionException = ex;
                                    subMonitor = this.getSubProgressMonitor(monitor, 50);
                                    break block30;
                                }
                            }
                            catch (Throwable throwable) {
                                subMonitor = this.getSubProgressMonitor(monitor, 50);
                                throw throwable;
                            }
                            subMonitor = this.getSubProgressMonitor(monitor, 50);
                        } else {
                            subMonitor = this.getSubProgressMonitor(monitor, listeners.length > 0 ? 70 : 100);
                        }
                    }
                    info.fCopy.commitWorkingCopy(isSynchronized || overwrite, subMonitor);
                    if (listeners.length > 0) {
                        this.notifyPostSaveListeners(info, changedRegions, listeners, this.getSubProgressMonitor(monitor, 30));
                    }
                    if (changedRegionException != null) {
                        throw changedRegionException;
                    }
                    info.fCopy.commitWorkingCopy(isSynchronized || overwrite, subMonitor);
                }
                catch (CoreException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
                catch (RuntimeException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
            }
            finally {
                this.fIsAboutToSave = false;
                if (subMonitor != null) {
                    subMonitor.done();
                }
            }
            if (info.fModel instanceof AbstractMarkerAnnotationModel) {
                AbstractMarkerAnnotationModel model = (AbstractMarkerAnnotationModel)info.fModel;
                model.updateMarkers(document);
            }
            if (this.fSavePolicy != null && (unit = this.fSavePolicy.postSave(info.fCopy)) != null && info.fModel instanceof AbstractMarkerAnnotationModel && (markers = (r = unit.getResource()).findMarkers("org.eclipse.core.resources.marker", true, 0)) != null && markers.length > 0) {
                AbstractMarkerAnnotationModel model = (AbstractMarkerAnnotationModel)info.fModel;
                int i = 0;
                while (i < markers.length) {
                    model.updateMarker(document, markers[i], null);
                    ++i;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public void connect(Object element) throws CoreException {
        super.connect(element);
        if (this.getFileInfo(element) != null) {
            return;
        }
        SourceModuleInfo info = this.fFakeCUMapForMissingInfo.get(element);
        if (info == null) {
            IModelElement e;
            ISourceModule cu = null;
            if (element instanceof IAdaptable && (e = (IModelElement)((IAdaptable)element).getAdapter(IModelElement.class)) != null && e instanceof ISourceModule) {
                cu = (ISourceModule)e;
            }
            DelegatingRequestor delegatingRequestor = null;
            if (cu == null) {
                delegatingRequestor = new DelegatingRequestor();
                cu = this.createFakeSourceModule(element, true, (IProblemRequestor)delegatingRequestor);
            }
            if (cu == null) {
                return;
            }
            info = new SourceModuleInfo();
            info.fCopy = cu;
            info.fElement = element;
            info.fModel = this.createAnnotationModel(element);
            if (delegatingRequestor != null) {
                delegatingRequestor.fRequestor = info.getProblemRequestor();
            }
            this.fFakeCUMapForMissingInfo.put(element, info);
        }
        info.fCount = info.fCount + 1;
    }

    private IAnnotationModel createAnnotationModel(Object element) {
        IPath path;
        IModelElement modelElement;
        if (element instanceof ExternalStorageEditorInput && (modelElement = (IModelElement)((ExternalStorageEditorInput)element).getAdapter(IModelElement.class)) != null && (path = modelElement.getPath()) != null) {
            return new ExternalSourceModuleAnnotationModel(path);
        }
        return new AnnotationModel();
    }

    public IAnnotationModel getAnnotationModel(Object element) {
        IAnnotationModel model = super.getAnnotationModel(element);
        if (model != null) {
            return model;
        }
        TextFileDocumentProvider.FileInfo info = this.fFakeCUMapForMissingInfo.get(element);
        if (info != null) {
            if (info.fModel != null) {
                return info.fModel;
            }
            if (info.fTextFileBuffer != null) {
                return info.fTextFileBuffer.getAnnotationModel();
            }
        }
        return null;
    }

    public void disconnect(Object element) {
        SourceModuleInfo info = this.fFakeCUMapForMissingInfo.get(element);
        if (info != null) {
            if (info.fCount == 1) {
                this.fFakeCUMapForMissingInfo.remove(element);
                info.fModel = null;
                try {
                    info.fCopy.discardWorkingCopy();
                }
                catch (ModelException ex) {
                    this.handleCoreException((CoreException)((Object)ex), ex.getMessage());
                }
            } else {
                info.fCount = info.fCount - 1;
            }
        }
        super.disconnect(element);
    }

    private ISourceModule createFakeSourceModule(Object element, boolean setContents, IProblemRequestor requestor) {
        if (element instanceof IStorageEditorInput) {
            return this.createFakeSourceModule((IStorageEditorInput)element, setContents, requestor);
        }
        if (element instanceof IURIEditorInput) {
            return this.createFakeSourceModule((IURIEditorInput)element, requestor);
        }
        if (element instanceof NonExistingFileEditorInput) {
            return this.createFakeSourceModule((NonExistingFileEditorInput)element, requestor);
        }
        return null;
    }

    private ISourceModule createFakeSourceModule(NonExistingFileEditorInput editorInput, IProblemRequestor requestor) {
        IFileStore fileStore;
        IPath path;
        block6: {
            try {
                path = editorInput.getPath((Object)editorInput);
                URI uri = URIUtil.toURI((IPath)path);
                fileStore = EFS.getStore((URI)uri);
                if (fileStore.getName() != null && path != null) break block6;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        WorkingCopyOwner woc = new WorkingCopyOwner(){

            public IBuffer createBuffer(ISourceModule workingCopy) {
                return new DocumentAdapter((IOpenable)workingCopy, fileStore, path);
            }
        };
        IBuildpathEntry[] cpEntries = null;
        IScriptProject jp = this.findScriptProject(path);
        if (jp != null) {
            cpEntries = jp.getResolvedBuildpath(true);
        }
        if (cpEntries == null || cpEntries.length == 0) {
            cpEntries = new IBuildpathEntry[]{ScriptRuntime.getDefaultInterpreterContainerEntry()};
        }
        ISourceModule cu = woc.newWorkingCopy(fileStore.getName(), cpEntries, requestor, this.getProgressMonitor());
        if (!this.isModifiable(editorInput)) {
            ScriptModelUtil.reconcile((ISourceModule)cu);
        }
        return cu;
    }

    private ISourceModule createFakeSourceModule(IURIEditorInput editorInput, IProblemRequestor requestor) {
        String fileStoreName;
        IPath path;
        IFileStore fileStore;
        block6: {
            try {
                URI uri = editorInput.getURI();
                fileStore = EFS.getStore((URI)uri);
                path = URIUtil.toPath((URI)uri);
                fileStoreName = fileStore.getName();
                if (fileStoreName != null && path != null) break block6;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        WorkingCopyOwner woc = new WorkingCopyOwner(){

            public IBuffer createBuffer(ISourceModule workingCopy) {
                return new DocumentAdapter((IOpenable)workingCopy, fileStore, path);
            }
        };
        IBuildpathEntry[] cpEntries = null;
        IScriptProject jp = this.findScriptProject(path);
        if (jp != null) {
            cpEntries = jp.getResolvedBuildpath(true);
        }
        if (cpEntries == null || cpEntries.length == 0) {
            cpEntries = new IBuildpathEntry[]{ScriptRuntime.getDefaultInterpreterContainerEntry()};
        }
        ISourceModule cu = woc.newWorkingCopy(fileStoreName, cpEntries, requestor, this.getProgressMonitor());
        if (!this.isModifiable(editorInput)) {
            ScriptModelUtil.reconcile((ISourceModule)cu);
        }
        return cu;
    }

    private ISourceModule createFakeSourceModule(IStorageEditorInput sei, boolean setContents, IProblemRequestor requestor) {
        IPath storagePath;
        IStorage storage;
        block10: {
            storage = sei.getStorage();
            storagePath = storage.getFullPath();
            if (storage.getName() != null && storagePath != null) break block10;
            return null;
        }
        try {
            WorkingCopyOwner woc = new WorkingCopyOwner(){

                public IBuffer createBuffer(ISourceModule workingCopy) {
                    return BufferManager.createBuffer((IOpenable)workingCopy);
                }
            };
            IBuildpathEntry[] cpEntries = null;
            IScriptProject jp = this.findScriptProject(storagePath);
            if (jp != null) {
                cpEntries = jp.getResolvedBuildpath(true);
            }
            if (cpEntries == null || cpEntries.length == 0) {
                cpEntries = new IBuildpathEntry[]{ScriptRuntime.getDefaultInterpreterContainerEntry()};
            }
            ISourceModule cu = woc.newWorkingCopy(storage.getName(), cpEntries, requestor, this.getProgressMonitor());
            if (setContents) {
                int READER_CHUNK_SIZE = 2048;
                int BUFFER_SIZE = 8 * READER_CHUNK_SIZE;
                BufferedReader in = new BufferedReader(new InputStreamReader(storage.getContents()));
                StringBuffer buffer = new StringBuffer(BUFFER_SIZE);
                char[] readBuffer = new char[READER_CHUNK_SIZE];
                try {
                    int n = in.read(readBuffer);
                    while (n > 0) {
                        buffer.append(readBuffer, 0, n);
                        n = in.read(readBuffer);
                    }
                    ((Reader)in).close();
                }
                catch (IOException e) {
                    DLTKUIPlugin.log(e);
                }
                cu.getBuffer().setContents(buffer.toString());
            }
            if (!this.isModifiable(sei)) {
                ScriptModelUtil.reconcile((ISourceModule)cu);
            }
            return cu;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private IScriptProject findScriptProject(IPath path) {
        IScriptProject[] projects;
        if (path == null) {
            return null;
        }
        String[] pathSegments = path.segments();
        IScriptModel model = DLTKCore.create((IWorkspaceRoot)DLTKUIPlugin.getWorkspace().getRoot());
        try {
            projects = model.getScriptProjects();
        }
        catch (ModelException modelException) {
            return null;
        }
        int i = 0;
        while (i < projects.length) {
            IPath projectPath = projects[i].getProject().getFullPath();
            String projectSegment = projectPath.segments()[0];
            int j = 0;
            while (j < pathSegments.length) {
                if (projectSegment.equals(pathSegments[j])) {
                    return projects[i];
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public boolean isReadOnly(Object element) {
        ISourceModule module;
        if (element instanceof ExternalStorageEditorInput) {
            return true;
        }
        if (element instanceof FileStoreEditorInput && (module = DLTKUIPlugin.resolveSourceModule((FileStoreEditorInput)element)) != null) {
            return module.isReadOnly();
        }
        return super.isReadOnly(element);
    }

    protected void notifyPostSaveListeners(final SourceModuleInfo info, final IRegion[] changedRegions, IPostSaveListener[] listeners, final IProgressMonitor monitor) throws CoreException {
        final ISourceModule unit = info.fCopy;
        final IBuffer buffer = unit.getBuffer();
        String message = DLTKEditorMessages.CompilationUnitDocumentProvider_error_saveParticipantProblem;
        final MultiStatus errorStatus = new MultiStatus("org.eclipse.dltk.ui", 10006, message, null);
        monitor.beginTask(DLTKEditorMessages.CompilationUnitDocumentProvider_progressNotifyingSaveParticipants, listeners.length * 5);
        try {
            int i = 0;
            while (i < listeners.length) {
                final IPostSaveListener listener = listeners[i];
                final String participantName = listener.getName();
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() {
                        try {
                            try {
                                long stamp = unit.getResource().getModificationStamp();
                                listener.saved(unit, changedRegions, SourceModuleDocumentProvider.this.getSubProgressMonitor(monitor, 4));
                                if (stamp != unit.getResource().getModificationStamp()) {
                                    String msg = NLS.bind((String)DLTKEditorMessages.CompilationUnitDocumentProvider_error_saveParticipantSavedFile, (Object)participantName);
                                    errorStatus.add((IStatus)new Status(4, "org.eclipse.dltk.ui", 10006, msg, null));
                                }
                                if (buffer.hasUnsavedChanges()) {
                                    buffer.save(SourceModuleDocumentProvider.this.getSubProgressMonitor(monitor, 1), true);
                                }
                            }
                            catch (CoreException ex) {
                                this.handleException(ex);
                                monitor.worked(1);
                            }
                        }
                        finally {
                            monitor.worked(1);
                        }
                    }

                    public void handleException(Throwable ex) {
                        String msg = NLS.bind((String)"The save participant ''{0}'' caused an exception: {1}", (Object)listener.getId(), (Object)ex.toString());
                        DLTKUIPlugin.log((IStatus)new Status(4, "org.eclipse.dltk.ui", 10006, msg, ex));
                        msg = NLS.bind((String)DLTKEditorMessages.CompilationUnitDocumentProvider_error_saveParticipantFailed, (Object)participantName, (Object)ex.toString());
                        errorStatus.add((IStatus)new Status(4, "org.eclipse.dltk.ui", 10006, msg, null));
                        if (buffer.hasUnsavedChanges()) {
                            try {
                                info.fTextFileBuffer.revert(SourceModuleDocumentProvider.this.getSubProgressMonitor(monitor, 1));
                            }
                            catch (CoreException coreException) {
                                msg = NLS.bind((String)"Error on revert after failure of save participant ''{0}''.", (Object)participantName);
                                Status status = new Status(4, "org.eclipse.dltk.ui", 10006, msg, ex);
                                DLTKUIPlugin.getDefault().getLog().log((IStatus)status);
                            }
                            if (info.fModel instanceof AbstractMarkerAnnotationModel) {
                                AbstractMarkerAnnotationModel markerModel = (AbstractMarkerAnnotationModel)info.fModel;
                                markerModel.resetMarkers();
                            }
                        }
                    }
                });
                ++i;
            }
        }
        finally {
            monitor.done();
            if (!errorStatus.isOK()) {
                throw new CoreException((IStatus)errorStatus);
            }
        }
    }

    static class DelegatingRequestor
    implements IProblemRequestor {
        IProblemRequestor fRequestor;

        DelegatingRequestor() {
        }

        public void acceptProblem(IProblem problem) {
            if (this.fRequestor != null) {
                this.fRequestor.acceptProblem(problem);
            }
        }

        public void beginReporting() {
            if (this.fRequestor != null) {
                this.fRequestor.beginReporting();
            }
        }

        public void endReporting() {
            if (this.fRequestor != null) {
                this.fRequestor.endReporting();
            }
        }

        public boolean isActive() {
            return this.fRequestor != null && this.fRequestor.isActive();
        }
    }

    protected static class ExternalSourceModuleAnnotationModel
    extends SourceModuleAnnotationModel {
        private final IPath location;

        public ExternalSourceModuleAnnotationModel(IPath location) {
            super((IResource)ResourcesPlugin.getWorkspace().getRoot());
            this.location = location;
        }

        protected IMarker[] retrieveMarkers() throws CoreException {
            String moduleLocation = this.location.toPortableString();
            IMarker[] markers = super.retrieveMarkers();
            LinkedList<IMarker> locationMarkers = new LinkedList<IMarker>();
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                String markerLocation = (String)marker.getAttribute("location");
                if (moduleLocation.equals(markerLocation)) {
                    locationMarkers.add(marker);
                }
                ++i;
            }
            return locationMarkers.toArray(new IMarker[locationMarkers.size()]);
        }

        protected void update(IMarkerDelta[] markerDeltas) {
            if (markerDeltas.length == 0) {
                return;
            }
            String moduleLocation = this.location.toPortableString();
            int i = 0;
            while (i < markerDeltas.length) {
                IMarkerDelta delta = markerDeltas[i];
                IMarker marker = delta.getMarker();
                if (moduleLocation.equals(marker.getAttribute("location", moduleLocation))) {
                    switch (delta.getKind()) {
                        case 1: {
                            this.addMarkerAnnotation(marker);
                            break;
                        }
                        case 2: {
                            this.removeMarkerAnnotation(marker);
                            break;
                        }
                        case 4: {
                            this.modifyMarkerAnnotation(marker);
                        }
                    }
                }
                ++i;
            }
            this.fireModelChanged();
        }
    }

    protected static class GlobalAnnotationModelListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        private ListenerList fListenerList = new ListenerList(1);

        public void modelChanged(IAnnotationModel model) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IAnnotationModelListener)listeners[i]).modelChanged(model);
                ++i;
            }
        }

        public void modelChanged(AnnotationModelEvent event) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                Object curr = listeners[i];
                if (curr instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)curr).modelChanged(event);
                }
                ++i;
            }
        }

        public void addListener(IAnnotationModelListener listener) {
            this.fListenerList.add((Object)listener);
        }

        public void removeListener(IAnnotationModelListener listener) {
            this.fListenerList.remove((Object)listener);
        }
    }

    public static class ProblemAnnotation
    extends Annotation
    implements IScriptAnnotation,
    IAnnotationPresentation,
    IQuickFixableAnnotation {
        public static final String SPELLING_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.spelling";
        private static final int TASK_LAYER;
        private static final int INFO_LAYER;
        private static final int WARNING_LAYER;
        private static final int ERROR_LAYER;
        private static Image fgQuickFixImage;
        private static Image fgQuickFixErrorImage;
        private static Image fgTaskImage;
        private static Image fgInfoImage;
        private static Image fgWarningImage;
        private static Image fgErrorImage;
        private static boolean fgImagesInitialized;
        private final ISourceModule fSourceModule;
        private List<IScriptAnnotation> fOverlaids;
        private final IProblem fProblem;
        private Image fImage;
        private boolean fImageInitialized = false;
        private int fLayer = 0;
        private boolean fIsQuickFixable;
        private boolean fIsQuickFixableStateSet = false;

        static {
            AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
            TASK_LAYER = ProblemAnnotation.computeLayer("org.eclipse.ui.workbench.texteditor.task", lookup);
            INFO_LAYER = ProblemAnnotation.computeLayer("org.eclipse.dltk.ui.info", lookup);
            WARNING_LAYER = ProblemAnnotation.computeLayer("org.eclipse.dltk.ui.warning", lookup);
            ERROR_LAYER = ProblemAnnotation.computeLayer("org.eclipse.dltk.ui.error", lookup);
            fgImagesInitialized = false;
        }

        private static int computeLayer(String annotationType, AnnotationPreferenceLookup lookup) {
            Annotation annotation = new Annotation(annotationType, false, null);
            AnnotationPreference preference = lookup.getAnnotationPreference(annotation);
            if (preference != null) {
                return preference.getPresentationLayer() + 1;
            }
            return 1;
        }

        public ProblemAnnotation(IProblem problem, ISourceModule cu) {
            this.fProblem = problem;
            this.fSourceModule = cu;
            if (SpellingProblems.SPELLING_PROBLEM == this.fProblem.getID()) {
                this.setType(SPELLING_ANNOTATION_TYPE);
                this.fLayer = WARNING_LAYER;
            } else if (this.fProblem.isTask()) {
                this.setType("org.eclipse.ui.workbench.texteditor.task");
                this.fLayer = TASK_LAYER;
            } else if (this.fProblem.isWarning()) {
                this.setType("org.eclipse.dltk.ui.warning");
                this.fLayer = WARNING_LAYER;
            } else if (this.fProblem.isError()) {
                this.setType("org.eclipse.dltk.ui.error");
                this.fLayer = ERROR_LAYER;
            } else {
                this.setType("org.eclipse.dltk.ui.info");
                this.fLayer = INFO_LAYER;
            }
        }

        public int getLayer() {
            return this.fLayer;
        }

        private void initializeImage() {
            if (!this.fImageInitialized) {
                ProblemAnnotation.initializeImages();
                if (!this.isQuickFixableStateSet()) {
                    this.setQuickFixable(this.isProblem() && ScriptAnnotationUtils.hasCorrections(this));
                }
                if (this.isQuickFixable()) {
                    this.fImage = "org.eclipse.dltk.ui.error".equals(this.getType()) ? fgQuickFixErrorImage : fgQuickFixImage;
                } else {
                    String type = this.getType();
                    if ("org.eclipse.ui.workbench.texteditor.task".equals(type)) {
                        this.fImage = fgTaskImage;
                    } else if ("org.eclipse.dltk.ui.info".equals(type)) {
                        this.fImage = fgInfoImage;
                    } else if ("org.eclipse.dltk.ui.warning".equals(type)) {
                        this.fImage = fgWarningImage;
                    } else if ("org.eclipse.dltk.ui.error".equals(type)) {
                        this.fImage = fgErrorImage;
                    }
                }
                this.fImageInitialized = true;
            }
        }

        private static void initializeImages() {
            if (fgImagesInitialized) {
                return;
            }
            fgQuickFixImage = DLTKPluginImages.get("org.eclipse.dltk.ui.quickfix_warning_obj.gif");
            fgQuickFixErrorImage = DLTKPluginImages.get("org.eclipse.dltk.ui.quickfix_error_obj.gif");
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            fgTaskImage = sharedImages.getImage("IMG_OBJS_TASK_TSK");
            fgInfoImage = sharedImages.getImage("IMG_OBJS_INFO_TSK");
            fgWarningImage = sharedImages.getImage("IMG_OBJS_WARN_TSK");
            fgErrorImage = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
            fgImagesInitialized = true;
        }

        public void paint(GC gc, Canvas canvas, Rectangle r) {
            this.initializeImage();
            if (this.fImage != null) {
                ImageUtilities.drawImage((Image)this.fImage, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
            }
        }

        public Image getImage(Display display) {
            this.initializeImage();
            return this.fImage;
        }

        @Override
        public String getText() {
            String[] arguments = this.getArguments();
            if (arguments != null) {
                int i = 0;
                while (i < arguments.length) {
                    String ar = arguments[i];
                    if (ar.startsWith("description:")) {
                        return String.valueOf(this.fProblem.getMessage()) + '\n' + ar.substring("description:".length());
                    }
                    ++i;
                }
            }
            return this.fProblem.getMessage();
        }

        @Override
        public String[] getArguments() {
            return this.isProblem() ? this.fProblem.getArguments() : null;
        }

        @Override
        public IProblemIdentifier getId() {
            return this.fProblem.getID();
        }

        @Override
        public boolean isProblem() {
            String type = this.getType();
            return "org.eclipse.dltk.ui.warning".equals(type) || "org.eclipse.dltk.ui.error".equals(type) || SPELLING_ANNOTATION_TYPE.equals(type);
        }

        @Override
        public boolean hasOverlay() {
            return false;
        }

        @Override
        public IScriptAnnotation getOverlay() {
            return null;
        }

        @Override
        public void addOverlaid(IScriptAnnotation annotation) {
            if (this.fOverlaids == null) {
                this.fOverlaids = new ArrayList<IScriptAnnotation>(1);
            }
            this.fOverlaids.add(annotation);
        }

        @Override
        public void removeOverlaid(IScriptAnnotation annotation) {
            if (this.fOverlaids != null) {
                this.fOverlaids.remove(annotation);
                if (this.fOverlaids.size() == 0) {
                    this.fOverlaids = null;
                }
            }
        }

        @Override
        public Iterator getOverlaidIterator() {
            if (this.fOverlaids != null) {
                return this.fOverlaids.iterator();
            }
            return null;
        }

        @Override
        public ISourceModule getSourceModule() {
            return this.fSourceModule;
        }

        public IProblem getProblem() {
            return this.fProblem;
        }

        @Override
        public String getMarkerType() {
            if (this.fProblem instanceof CategorizedProblem) {
                return ((CategorizedProblem)this.fProblem).getMarkerType();
            }
            return null;
        }

        public void setQuickFixable(boolean state) {
            this.fIsQuickFixable = state;
            this.fIsQuickFixableStateSet = true;
        }

        public boolean isQuickFixableStateSet() {
            return this.fIsQuickFixableStateSet;
        }

        public boolean isQuickFixable() {
            Assert.isTrue((boolean)this.isQuickFixableStateSet());
            return this.fIsQuickFixable;
        }

        @Override
        public int getSourceStart() {
            return this.fProblem.getSourceStart();
        }

        @Override
        public int getSourceEnd() {
            return this.fProblem.getSourceEnd();
        }
    }

    protected static class ReverseMap {
        private List<Entry> fList = new ArrayList<Entry>(2);
        private int fAnchor = 0;

        public Object get(Position position) {
            Entry entry;
            int length = this.fList.size();
            int i = this.fAnchor;
            while (i < length) {
                entry = this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            i = 0;
            while (i < this.fAnchor) {
                entry = this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            return null;
        }

        private int getIndex(Position position) {
            int length = this.fList.size();
            int i = 0;
            while (i < length) {
                Entry entry = this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void put(Position position, Object value) {
            int index = this.getIndex(position);
            if (index == -1) {
                Entry entry = new Entry();
                entry.fPosition = position;
                entry.fValue = value;
                this.fList.add(entry);
            } else {
                Entry entry = this.fList.get(index);
                entry.fValue = value;
            }
        }

        public void remove(Position position) {
            int index = this.getIndex(position);
            if (index > -1) {
                this.fList.remove(index);
            }
        }

        public void clear() {
            this.fList.clear();
        }

        static class Entry {
            Position fPosition;
            Object fValue;

            Entry() {
            }
        }
    }

    public static class SourceModuleAnnotationModel
    extends ResourceMarkerAnnotationModel
    implements IProblemRequestor,
    IProblemRequestorExtension {
        private ThreadLocal<ProblemRequestorState> fProblemRequestorState = new ThreadLocal();
        private int fStateCount = 0;
        private ISourceModule fSourceModule;
        private List<Annotation> fGeneratedAnnotations = new ArrayList<Annotation>();
        private IProgressMonitor fProgressMonitor;
        private boolean fIsActive = false;
        private boolean fIsHandlingTemporaryProblems;
        private ReverseMap fReverseMap = new ReverseMap();
        private List<ScriptMarkerAnnotation> fPreviouslyOverlaid = null;
        private List<ScriptMarkerAnnotation> fCurrentlyOverlaid = new ArrayList<ScriptMarkerAnnotation>();
        protected IProblemFactory problemFactory;

        public SourceModuleAnnotationModel(IResource resource) {
            super(resource);
        }

        public void setSourceModule(ISourceModule unit) {
            this.fSourceModule = unit;
        }

        protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
            if (this.isScriptMarker(marker)) {
                return new ScriptMarkerAnnotation(marker);
            }
            return super.createMarkerAnnotation(marker);
        }

        private boolean isScriptMarker(IMarker marker) {
            if (this.problemFactory != null) {
                return this.problemFactory.isValidMarker(marker);
            }
            String markerType = MarkerUtilities.getMarkerType((IMarker)marker);
            return markerType != null && markerType.startsWith("org.eclipse.dltk");
        }

        protected AnnotationModelEvent createAnnotationModelEvent() {
            return new SourceModuleAnnotationModelEvent((IAnnotationModel)this, this.getResource());
        }

        protected Position createPositionFromProblem(IProblem problem) {
            int start = problem.getSourceStart();
            int end = problem.getSourceEnd();
            if (start <= 0 && end <= 0) {
                return new Position(0);
            }
            if (start < 0) {
                return new Position(end);
            }
            if (end < 0) {
                return new Position(start);
            }
            int length = end - start;
            if (length < 0) {
                return null;
            }
            if (this.fDocument != null) {
                int documentLength = this.fDocument.getLength();
                if (start > documentLength) {
                    start = documentLength;
                }
                if (start + length > documentLength) {
                    length = documentLength - start;
                }
            }
            return new Position(start, length);
        }

        public void beginReporting() {
            ProblemRequestorState state = this.fProblemRequestorState.get();
            if (state == null) {
                this.internalBeginReporting(false);
            }
        }

        @Override
        public void beginReportingSequence() {
            ProblemRequestorState state = this.fProblemRequestorState.get();
            if (state == null) {
                this.internalBeginReporting(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalBeginReporting(boolean insideReportingSequence) {
            if (this.fSourceModule != null && !this.fSourceModule.isReadOnly()) {
                ProblemRequestorState state = new ProblemRequestorState();
                state.fInsideReportingSequence = insideReportingSequence;
                state.fReportedProblems = new ArrayList<IProblem>();
                Object object = this.getLockObject();
                synchronized (object) {
                    this.fProblemRequestorState.set(state);
                    ++this.fStateCount;
                }
            }
        }

        public void acceptProblem(IProblem problem) {
            ProblemRequestorState state;
            if ((this.fIsHandlingTemporaryProblems || problem.getID() == SpellingProblems.SPELLING_PROBLEM) && (state = this.fProblemRequestorState.get()) != null) {
                state.fReportedProblems.add(problem);
            }
        }

        public void endReporting() {
            ProblemRequestorState state = this.fProblemRequestorState.get();
            if (state != null && !state.fInsideReportingSequence) {
                this.internalEndReporting(state);
            }
        }

        @Override
        public void endReportingSequence() {
            ProblemRequestorState state = this.fProblemRequestorState.get();
            if (state != null && state.fInsideReportingSequence) {
                this.internalEndReporting(state);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalEndReporting(ProblemRequestorState state) {
            int stateCount = 0;
            Object object = this.getLockObject();
            synchronized (object) {
                --this.fStateCount;
                stateCount = this.fStateCount;
                this.fProblemRequestorState.set(null);
            }
            if (stateCount == 0) {
                this.reportProblems(state.fReportedProblems);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reportProblems(List<IProblem> reportedProblems) {
            if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                return;
            }
            boolean temporaryProblemsChanged = false;
            Object object = this.getLockObject();
            synchronized (object) {
                boolean isCanceled = false;
                this.fPreviouslyOverlaid = this.fCurrentlyOverlaid;
                this.fCurrentlyOverlaid = new ArrayList<ScriptMarkerAnnotation>();
                if (this.fGeneratedAnnotations.size() > 0) {
                    temporaryProblemsChanged = true;
                    this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                    this.fGeneratedAnnotations.clear();
                }
                if (reportedProblems != null && reportedProblems.size() > 0) {
                    Iterator<IProblem> e = reportedProblems.iterator();
                    while (e.hasNext()) {
                        if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                            isCanceled = true;
                            break;
                        }
                        IProblem problem = e.next();
                        Position position = this.createPositionFromProblem(problem);
                        if (position == null) continue;
                        try {
                            Object annotation;
                            if (problem instanceof ScriptSpellingProblem) {
                                annotation = new SpellingAnnotation(((ScriptSpellingProblem)problem).getSpellingProblem());
                                this.addAnnotation((Annotation)annotation, position, false);
                                this.fGeneratedAnnotations.add((Annotation)annotation);
                            }
                            annotation = new ProblemAnnotation(problem, this.fSourceModule);
                            this.overlayMarkers(position, (ProblemAnnotation)annotation);
                            this.addAnnotation((Annotation)annotation, position, false);
                            this.fGeneratedAnnotations.add((Annotation)annotation);
                            temporaryProblemsChanged = true;
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
                this.removeMarkerOverlays(isCanceled);
                this.fPreviouslyOverlaid = null;
            }
            if (temporaryProblemsChanged) {
                this.fireModelChanged();
            }
        }

        private void removeMarkerOverlays(boolean isCanceled) {
            if (isCanceled) {
                this.fCurrentlyOverlaid.addAll(this.fPreviouslyOverlaid);
            } else if (this.fPreviouslyOverlaid != null) {
                for (ScriptMarkerAnnotation annotation : this.fPreviouslyOverlaid) {
                    annotation.setOverlay(null);
                }
            }
        }

        private void setOverlay(Object value, ProblemAnnotation problemAnnotation) {
            ScriptMarkerAnnotation annotation;
            if (value instanceof ScriptMarkerAnnotation && (annotation = (ScriptMarkerAnnotation)value).isProblem()) {
                annotation.setOverlay(problemAnnotation);
                this.fPreviouslyOverlaid.remove(annotation);
                this.fCurrentlyOverlaid.add(annotation);
            }
        }

        private void overlayMarkers(Position position, ProblemAnnotation problemAnnotation) {
            Object value = this.getAnnotations(position);
            if (value instanceof List) {
                List list = (List)value;
                Iterator e = list.iterator();
                while (e.hasNext()) {
                    this.setOverlay(e.next(), problemAnnotation);
                }
            } else {
                this.setOverlay(value, problemAnnotation);
            }
        }

        private void startCollectingProblems() {
            this.fGeneratedAnnotations.clear();
        }

        private void stopCollectingProblems() {
            if (this.fGeneratedAnnotations != null) {
                this.removeAnnotations(this.fGeneratedAnnotations, true, true);
            }
            this.fGeneratedAnnotations.clear();
        }

        public boolean isActive() {
            return this.fIsActive;
        }

        @Override
        public void setProgressMonitor(IProgressMonitor monitor) {
            this.fProgressMonitor = monitor;
        }

        @Override
        public void setIsActive(boolean isActive) {
            this.fIsActive = isActive;
        }

        @Override
        public void setIsHandlingTemporaryProblems(boolean enable) {
            if (this.fIsHandlingTemporaryProblems != enable) {
                this.fIsHandlingTemporaryProblems = enable;
                if (this.fIsHandlingTemporaryProblems) {
                    this.startCollectingProblems();
                } else {
                    this.stopCollectingProblems();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getAnnotations(Position position) {
            Object object = this.getLockObject();
            synchronized (object) {
                return this.fReverseMap.get(position);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) throws BadLocationException {
            super.addAnnotation(annotation, position, fireModelChanged);
            Object object = this.getLockObject();
            synchronized (object) {
                Object cached = this.fReverseMap.get(position);
                if (cached == null) {
                    this.fReverseMap.put(position, annotation);
                } else if (cached instanceof List) {
                    List list = (List)cached;
                    list.add(annotation);
                } else if (cached instanceof Annotation) {
                    ArrayList<Annotation> list = new ArrayList<Annotation>(2);
                    list.add((Annotation)cached);
                    list.add(annotation);
                    this.fReverseMap.put(position, list);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeAllAnnotations(boolean fireModelChanged) {
            super.removeAllAnnotations(fireModelChanged);
            Object object = this.getLockObject();
            synchronized (object) {
                this.fReverseMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
            Position position = this.getPosition(annotation);
            Object object = this.getLockObject();
            synchronized (object) {
                Object cached = this.fReverseMap.get(position);
                if (cached instanceof List) {
                    List list = (List)cached;
                    list.remove(annotation);
                    if (list.size() == 1) {
                        this.fReverseMap.put(position, list.get(0));
                        list.clear();
                    }
                } else if (cached instanceof Annotation) {
                    this.fReverseMap.remove(position);
                }
            }
            super.removeAnnotation(annotation, fireModelChanged);
        }

        private static class ProblemRequestorState {
            boolean fInsideReportingSequence = false;
            List<IProblem> fReportedProblems;

            private ProblemRequestorState() {
            }
        }
    }

    protected static class SourceModuleInfo
    extends TextFileDocumentProvider.FileInfo {
        public ISourceModule fCopy;

        public IProblemRequestor getProblemRequestor() {
            return this.fModel instanceof IProblemRequestor ? (IProblemRequestor)this.fModel : null;
        }
    }
}

