/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.completion;

import org.eclipse.dltk.ui.text.completion.ScriptCompletionProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.ui.IEditorPart;

public class JavaScriptCompletionProcessor
extends ScriptCompletionProcessor {
    public JavaScriptCompletionProcessor(IEditorPart editor, ContentAssistant assistant, String partition) {
        super(editor, assistant, partition);
    }

    protected String getNatureId() {
        return "org.eclipse.dltk.javascript.core.nature";
    }

    protected IContextInformationValidator createContextInformationValidator() {
        return new JavaScriptParameterListValidator();
    }

    protected static class JavaScriptParameterListValidator
    extends ScriptCompletionProcessor.ScriptParameterListValidator {
        protected int installOffset;
        private IContextInformation info;
        private ITextViewer viewer;

        protected JavaScriptParameterListValidator() {
        }

        public boolean isContextInformationValid(int offset) {
            if (offset < this.installOffset) {
                return false;
            }
            try {
                String txt = this.viewer.getDocument().get(this.installOffset, offset - this.installOffset);
                int counter = 0;
                int inBracket = 0;
                while (counter < txt.length()) {
                    char ch = txt.charAt(counter++);
                    switch (ch) {
                        case '(': {
                            ++inBracket;
                            break;
                        }
                        case ')': {
                            --inBracket;
                        }
                    }
                }
                return inBracket >= 0;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                return false;
            }
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.info = info;
            this.viewer = viewer;
            this.installOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            block8: {
                if (documentPosition >= this.installOffset) break block8;
                return false;
            }
            try {
                String text = this.viewer.getDocument().get(this.installOffset, documentPosition - this.installOffset);
                int count = 0;
                int i = 0;
                while (i < text.length()) {
                    if (text.charAt(i) == ',') {
                        ++count;
                    }
                    ++i;
                }
                StyleRange styleRange = presentation.getFirstStyleRange();
                if (styleRange == null) {
                    styleRange = new StyleRange();
                    styleRange.fontStyle = 1;
                    presentation.addStyleRange(styleRange);
                }
                String informationDisplayString = this.info.getInformationDisplayString();
                int index = 0;
                while (count > 0 && index != -1) {
                    if ((index = informationDisplayString.indexOf(44, index)) == -1) continue;
                    --count;
                    ++index;
                }
                if (index != -1) {
                    styleRange.start = index;
                    styleRange.length = (index = informationDisplayString.indexOf(44, index + 1)) == -1 ? informationDisplayString.length() - styleRange.start : index - styleRange.start;
                    return true;
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            return false;
        }
    }
}

