/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.dltk.internal.javascript.typeinference.IProposalHolder;

public class FakeField
extends SourceField
implements IProposalHolder {
    private int offset;
    private int length;
    private String snippet;
    private String proposalInfo;
    private final String type;

    public FakeField(ModelElement parent, String name, int offset, int length) {
        this(parent, name, offset, length, null);
    }

    public FakeField(ModelElement parent, String name, int offset, int length, String type) {
        super(parent, name);
        this.offset = offset;
        this.length = length;
        this.type = type;
    }

    public ISourceRange getNameRange() throws ModelException {
        if (this.offset == 0 && this.length == 0) {
            return super.getNameRange();
        }
        return new SourceRange(this.offset, this.length);
    }

    public ISourceRange getSourceRange() throws ModelException {
        if (this.offset == 0 && this.length == 0) {
            if (this.getElementInfo() == null) {
                return null;
            }
            return super.getSourceRange();
        }
        return new SourceRange(this.offset, this.length);
    }

    public String getSnippet() {
        return this.snippet;
    }

    public String getType() throws ModelException {
        return this.type;
    }

    public boolean exists() {
        return true;
    }

    public void setSnippet(String snippet) {
        this.snippet = snippet;
    }

    public void setProposalInfo(String proposalInfo) {
        this.proposalInfo = proposalInfo;
    }

    public String getProposalInfo() {
        return this.proposalInfo;
    }

    public IOpenable getOpenableParent() {
        IOpenable openableParent = super.getOpenableParent();
        try {
            openableParent.getBuffer();
        }
        catch (Exception exception) {
            return null;
        }
        return openableParent;
    }
}

