/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.DebugRunnerDelegate;
import org.eclipse.dltk.internal.launching.IInterpreterInstallExtensionContainer;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.ExecutionArguments;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallChangedListener;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.IInterpreterRunner;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.PropertyChangeEvent;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInterpreterInstall
implements IInterpreterInstall,
IInterpreterInstallExtensionContainer {
    private IInterpreterInstallType fType;
    private String fId;
    private String fName;
    private IFileHandle fInstallLocation;
    private LibraryLocation[] fSystemLibraryDescriptions;
    private String fInterpreterArgs;
    private EnvironmentVariable[] fEnvironmentVariables;
    private boolean fNotify = true;
    private XMLResource resource = null;
    private static final String ENCODING = "UTF-8";

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fNotify) {
            ScriptRuntime.fireInterpreterChanged(event);
        }
    }

    public AbstractInterpreterInstall(IInterpreterInstallType type, String id) {
        if (type == null || id == null) {
            throw new IllegalArgumentException();
        }
        this.fType = type;
        this.fId = id;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getNatureId() {
        return this.fType.getNatureId();
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        if (!name.equals(this.fName)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_NAME, this.fName, name);
            this.fName = name;
            this.firePropertyChangeEvent(event);
        }
    }

    @Override
    public IFileHandle getInstallLocation() {
        return this.fInstallLocation;
    }

    @Override
    public IFileHandle getRawInstallLocation() {
        return this.fInstallLocation;
    }

    @Override
    public IEnvironment getEnvironment() {
        if (this.fInstallLocation != null) {
            return this.fInstallLocation.getEnvironment();
        }
        return null;
    }

    @Override
    public String getEnvironmentId() {
        if (this.fInstallLocation != null) {
            return this.fInstallLocation.getEnvironmentId();
        }
        return null;
    }

    @Override
    public IExecutionEnvironment getExecEnvironment() {
        IEnvironment environment = this.getEnvironment();
        if (environment != null) {
            return (IExecutionEnvironment)environment.getAdapter(IExecutionEnvironment.class);
        }
        return null;
    }

    @Override
    public void setInstallLocation(IFileHandle installLocation) {
        if (!installLocation.equals(this.fInstallLocation)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_INSTALL_LOCATION, this.fInstallLocation, installLocation);
            this.fInstallLocation = installLocation;
            this.firePropertyChangeEvent(event);
        }
    }

    @Override
    public IInterpreterInstallType getInterpreterInstallType() {
        return this.fType;
    }

    @Override
    public LibraryLocation[] getLibraryLocations() {
        return this.fSystemLibraryDescriptions;
    }

    @Override
    public void setLibraryLocations(LibraryLocation[] locations) {
        LibraryLocation[] prevLocations;
        if (locations == this.fSystemLibraryDescriptions) {
            return;
        }
        LibraryLocation[] newLocations = locations;
        if (newLocations == null) {
            newLocations = this.getInterpreterInstallType().getDefaultLibraryLocations(this.getInstallLocation(), this.getEnvironmentVariables(), null);
        }
        if ((prevLocations = this.fSystemLibraryDescriptions) == null) {
            prevLocations = this.getInterpreterInstallType().getDefaultLibraryLocations(this.getInstallLocation(), this.getEnvironmentVariables(), null);
        }
        if (newLocations.length == prevLocations.length) {
            int i = 0;
            boolean equal = true;
            while (i < newLocations.length && equal) {
                equal = newLocations[i].equals(prevLocations[i]);
                ++i;
            }
            if (equal) {
                return;
            }
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_LIBRARY_LOCATIONS, prevLocations, newLocations);
        this.fSystemLibraryDescriptions = locations;
        this.firePropertyChangeEvent(event);
    }

    protected void setNotify(boolean notify) {
        this.fNotify = notify;
    }

    public boolean equals(Object object) {
        if (object instanceof IInterpreterInstall) {
            IInterpreterInstall Interpreter = (IInterpreterInstall)object;
            return this.getInterpreterInstallType().equals(Interpreter.getInterpreterInstallType()) && this.getId().equals(Interpreter.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getInterpreterInstallType().hashCode() + this.getId().hashCode();
    }

    @Override
    public String[] getInterpreterArguments() {
        String args = this.getInterpreterArgs();
        if (args == null) {
            return null;
        }
        ExecutionArguments ex = new ExecutionArguments(args, "");
        return ex.getInterpreterArgumentsArray();
    }

    @Override
    public void setInterpreterArguments(String[] args) {
        if (args == null) {
            this.setInterpreterArgs(null);
        } else {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < args.length) {
                String string = args[i];
                buf.append(string);
                buf.append(' ');
                ++i;
            }
            this.setInterpreterArgs(buf.toString().trim());
        }
    }

    @Override
    public String getInterpreterArgs() {
        return this.fInterpreterArgs;
    }

    @Override
    public void setInterpreterArgs(String args) {
        if (this.fInterpreterArgs == null ? args == null : this.fInterpreterArgs.equals(args)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_Interpreter_ARGUMENTS, this.fInterpreterArgs, args);
        this.fInterpreterArgs = args;
        this.firePropertyChangeEvent(event);
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public String[] getBuiltinModules() {
        return null;
    }

    public String getBuiltinModuleContent(String name) {
        return null;
    }

    public long lastModified() {
        return 0L;
    }

    protected IInterpreterRunner getDebugInterpreterRunner() {
        return new DebugRunnerDelegate(this);
    }

    @Override
    public IInterpreterRunner getInterpreterRunner(String mode) {
        if (mode.equals("debug")) {
            return this.getDebugInterpreterRunner();
        }
        return null;
    }

    @Override
    public EnvironmentVariable[] getEnvironmentVariables() {
        return this.fEnvironmentVariables;
    }

    @Override
    public void setEnvironmentVariables(EnvironmentVariable[] variables) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_ENVIRONMENT_VARIABLES, this.fEnvironmentVariables, variables);
        this.fEnvironmentVariables = variables;
        this.firePropertyChangeEvent(event);
    }

    protected XMIResource createResource() {
        XMIResourceImpl r = new XMIResourceImpl();
        r.setEncoding(ENCODING);
        return r;
    }

    @Override
    public EObject findExtension(EClass clazz) {
        if (this.resource != null) {
            for (EObject object : this.resource.getContents()) {
                if (!clazz.equals(object.eClass())) continue;
                return object;
            }
        }
        return null;
    }

    @Override
    public EObject replaceExtension(EClass clazz, EObject value) {
        if (value != null) {
            Assert.isLegal((boolean)clazz.equals(value.eClass()));
        }
        if (this.resource == null) {
            this.resource = this.createResource();
        }
        ListIterator i = this.resource.getContents().listIterator();
        while (i.hasNext()) {
            EObject object = (EObject)i.next();
            if (!clazz.equals(object.eClass())) continue;
            if (value != null) {
                i.set(value);
            } else {
                i.remove();
            }
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_EXTENSIONS, Collections.singletonList(object), value != null ? Collections.singletonList(value) : null));
            return object;
        }
        if (value != null) {
            this.resource.getContents().add((Object)value);
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_EXTENSIONS, null, Collections.singletonList(value)));
        }
        return null;
    }

    @Override
    public List<EObject> copyExtensions() {
        if (this.resource != null && !this.resource.getContents().isEmpty()) {
            Collection copy = EcoreUtil.copyAll((Collection)this.resource.getContents());
            if (copy instanceof List) {
                return (List)copy;
            }
            return new ArrayList<EObject>(copy);
        }
        return Collections.emptyList();
    }

    @Override
    public List<EObject> getExtensions() {
        if (this.resource != null && !this.resource.getContents().isEmpty()) {
            return new ArrayList<EObject>((Collection<EObject>)this.resource.getContents());
        }
        return Collections.emptyList();
    }

    @Override
    public void setExtensions(List<EObject> value) {
        ArrayList oldValue;
        if (this.resource == null) {
            this.resource = this.createResource();
            oldValue = null;
        } else {
            oldValue = new ArrayList(this.resource.getContents());
            this.resource.getContents().clear();
        }
        this.resource.getContents().addAll(value);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_EXTENSIONS, oldValue, value));
    }

    @Override
    public String saveExtensions() {
        if (this.resource != null && !this.resource.getContents().isEmpty()) {
            StringWriter stringWriter;
            block3: {
                stringWriter = new StringWriter();
                try {
                    HashMap<String, Boolean> saveOptions = new HashMap<String, Boolean>();
                    saveOptions.put("DECLARE_XML", Boolean.FALSE);
                    saveOptions.put("FORMATTED", Boolean.FALSE);
                    this.resource.save((OutputStream)new URIConverter.WriteableOutputStream((Writer)stringWriter, ENCODING), saveOptions);
                }
                catch (IOException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
            return stringWriter.toString();
        }
        return null;
    }

    @Override
    public void loadExtensions(String value) {
        if (value != null && value.length() != 0) {
            if (this.resource == null) {
                this.resource = this.createResource();
            }
            try {
                this.resource.load((InputStream)new URIConverter.ReadableInputStream(value, ENCODING), null);
            }
            catch (IOException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
        } else if (this.resource != null) {
            this.resource.getContents().clear();
        }
    }
}

