/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.viewsupport;

import java.util.ArrayList;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.UIModelProviderManager;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.dltk.ui.viewsupport.StorageLabelProvider;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class ScriptUILabelProvider
implements ILabelProvider,
IColorProvider {
    protected ListenerList fListeners = new ListenerList(1);
    protected ScriptElementImageProvider fImageLabelProvider = new ScriptElementImageProvider();
    protected StorageLabelProvider fStorageLabelProvider = new StorageLabelProvider();
    private int fImageFlags;
    private long fTextFlags;
    private ArrayList<ILabelDecorator> fLabelDecorators;
    private ImageDescriptorRegistry localRegistry = null;

    public ScriptUILabelProvider() {
        this(ScriptElementLabels.ALL_DEFAULT, 1);
        this.fLabelDecorators = null;
    }

    public ScriptUILabelProvider(long textFlags, int imageFlags) {
        this.fImageFlags = imageFlags;
        this.fTextFlags = textFlags;
        this.fLabelDecorators = null;
    }

    public final void setTextFlags(long textFlags) {
        this.fTextFlags = textFlags;
    }

    public final void setImageFlags(int imageFlags) {
        this.fImageFlags = imageFlags;
    }

    public final int getImageFlags() {
        return this.fImageFlags;
    }

    public final long getTextFlags() {
        return this.fTextFlags;
    }

    protected int evaluateImageFlags(Object element) {
        return this.getImageFlags();
    }

    protected long evaluateTextFlags(Object element) {
        return this.getTextFlags();
    }

    public Image getImage(Object element) {
        ILabelProvider[] providers = this.getProviders(element);
        int flags = this.evaluateImageFlags(element);
        Image result = null;
        if (providers != null) {
            int i = 0;
            while (i < providers.length) {
                Image image = providers[i].getImage(element);
                if (image != null) {
                    if (ScriptElementImageProvider.useSmallSize(flags)) {
                        result = image;
                        break;
                    }
                    result = this.getLocalRegistry().get((ImageDescriptor)new BigImageDescriptor(image, ScriptElementImageProvider.BIG_SIZE));
                    break;
                }
                ++i;
            }
        }
        if (result == null) {
            result = this.fImageLabelProvider.getImageLabel(element, flags);
        }
        if (result == null && (element instanceof IStorage || element instanceof ISourceModule) && (result = this.fStorageLabelProvider.getImage(element)) != null && !ScriptElementImageProvider.useSmallSize(flags)) {
            result = this.getLocalRegistry().get((ImageDescriptor)new BigImageDescriptor(result, ScriptElementImageProvider.BIG_SIZE));
        }
        return this.decorateImage(result, element);
    }

    private ImageDescriptorRegistry getLocalRegistry() {
        if (this.localRegistry == null) {
            this.localRegistry = new ImageDescriptorRegistry(false);
        }
        return this.localRegistry;
    }

    public String getText(Object element) {
        ILabelProvider[] providers = this.getProviders(element);
        String result = null;
        if (providers != null) {
            int i = 0;
            while (i < providers.length) {
                String text = providers[i].getText(element);
                if (text != null) {
                    result = text;
                    break;
                }
                ++i;
            }
        }
        if (result == null) {
            result = ScriptElementLabels.getDefault().getTextLabel(element, this.evaluateTextFlags(element));
        }
        if (result.length() == 0 && element instanceof IStorage) {
            result = this.fStorageLabelProvider.getText(element);
        }
        return this.decorateText(result, element);
    }

    private ILabelProvider[] getProviders(Object element) {
        IDLTKLanguageToolkit toolkit;
        String idtoolkit = null;
        if (element instanceof IModelElement && (toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)((IModelElement)element))) != null) {
            idtoolkit = toolkit.getNatureId();
        }
        ILabelProvider[] providers = UIModelProviderManager.getLabelProviders(idtoolkit);
        return providers;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fLabelDecorators != null) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = this.fLabelDecorators.get(i);
                decorator.addListener(listener);
                ++i;
            }
        }
        this.fListeners.add((Object)listener);
    }

    public void dispose() {
        if (this.fLabelDecorators != null) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = this.fLabelDecorators.get(i);
                decorator.dispose();
                ++i;
            }
            this.fLabelDecorators = null;
        }
        if (this.localRegistry != null) {
            this.localRegistry.dispose();
            this.localRegistry = null;
        }
        this.fStorageLabelProvider.dispose();
        this.fImageLabelProvider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fLabelDecorators != null) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = this.fLabelDecorators.get(i);
                decorator.removeListener(listener);
                ++i;
            }
        }
        this.fListeners.remove((Object)listener);
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ILabelProviderListener l = (ILabelProviderListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.labelProviderChanged(event);
                }
            });
            ++i;
        }
    }

    public void addLabelDecorator(ILabelDecorator decorator) {
        if (this.fLabelDecorators == null) {
            this.fLabelDecorators = new ArrayList(2);
        }
        this.fLabelDecorators.add(decorator);
    }

    protected Image decorateImage(Image image, Object element) {
        if (this.fLabelDecorators != null && image != null) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = this.fLabelDecorators.get(i);
                image = decorator.decorateImage(image, element);
                ++i;
            }
        }
        return image;
    }

    protected String decorateText(String text, Object element) {
        if (this.fLabelDecorators != null && text.length() > 0) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = this.fLabelDecorators.get(i);
                text = decorator.decorateText(text, element);
                ++i;
            }
        }
        return text;
    }

    private static class BigImageDescriptor
    extends CompositeImageDescriptor {
        private final Point fSize;
        private final Image fBaseImage;

        public BigImageDescriptor(Image baseImage, Point size) {
            this.fBaseImage = baseImage;
            Assert.isNotNull((Object)this.fBaseImage);
            this.fSize = size;
            Assert.isNotNull((Object)this.fSize);
        }

        protected Point getSize() {
            return this.fSize;
        }

        public boolean equals(Object object) {
            if (object == null || !BigImageDescriptor.class.equals(object.getClass())) {
                return false;
            }
            BigImageDescriptor other = (BigImageDescriptor)((Object)object);
            return this.fBaseImage.equals((Object)other.fBaseImage) && this.fSize.equals((Object)other.fSize);
        }

        public int hashCode() {
            return this.fBaseImage.hashCode() ^ this.fSize.hashCode();
        }

        protected void drawCompositeImage(int width, int height) {
            ImageData bg = this.fBaseImage.getImageData();
            if (bg != null) {
                this.drawImage(bg, 0, 0);
            }
        }
    }
}

