/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.typehierarchy;

import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.typehierarchy.HistoryAction;
import org.eclipse.dltk.internal.ui.typehierarchy.HistoryListAction;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class HistoryDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private TypeHierarchyViewPart fHierarchyView;
    private Menu fMenu;

    public HistoryDropDownAction(TypeHierarchyViewPart view) {
        this.fHierarchyView = view;
        this.fMenu = null;
        this.setToolTipText(TypeHierarchyMessages.HistoryDropDownAction_tooltip);
        DLTKPluginImages.setLocalImageDescriptors((IAction)this, "history_list.gif");
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        IModelElement[] elements = this.fHierarchyView.getHistoryEntries();
        this.addEntries(this.fMenu, elements);
        new MenuItem(this.fMenu, 2);
        this.addActionToMenu(this.fMenu, new HistoryListAction(this.fHierarchyView));
        this.addActionToMenu(this.fMenu, new ClearHistoryAction(this.fHierarchyView));
        return this.fMenu;
    }

    private boolean addEntries(Menu menu, IModelElement[] elements) {
        boolean checked = false;
        int min = Math.min(elements.length, 10);
        int i = 0;
        while (i < min) {
            HistoryAction action = new HistoryAction(this.fHierarchyView, elements[i]);
            action.setChecked(elements[i].equals(this.fHierarchyView.getInputElement()));
            checked = checked || action.isChecked();
            this.addActionToMenu(menu, action);
            ++i;
        }
        return checked;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        new HistoryListAction(this.fHierarchyView).run();
    }

    public static class ClearHistoryAction
    extends Action {
        private TypeHierarchyViewPart fView;

        public ClearHistoryAction(TypeHierarchyViewPart view) {
            super(TypeHierarchyMessages.HistoryDropDownAction_clearhistory_label);
            this.fView = view;
        }

        public void run() {
            this.fView.setHistoryEntries(new IModelElement[0]);
            this.fView.setInputElement(null);
        }
    }
}

