/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.utils.DLTKLogging;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLTKLoggingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTableViewer viewer;

    public DLTKLoggingPreferencePage() {
        this.setDescription("Logging options for dynamic languages");
    }

    protected Control createContents(Composite parent) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)67584);
        this.viewer.setContentProvider((IContentProvider)new OptionContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new OptionLableProvider());
        List<Option> options = this.collectOptions();
        this.viewer.setInput(options);
        HashSet<String> optionIds = new HashSet<String>();
        for (Option option : options) {
            optionIds.add(option.id);
        }
        Map state = DLTKLogging.getState(optionIds);
        ArrayList<Option> checked = new ArrayList<Option>();
        for (Option option : options) {
            Boolean value = (Boolean)state.get(option.id);
            if (value == null || !value.booleanValue()) continue;
            checked.add(option);
        }
        this.viewer.setCheckedElements(checked.toArray());
        return this.viewer.getControl();
    }

    private List<Option> collectOptions() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dltk.core.loggingOptions");
        ArrayList<Option> options = new ArrayList<Option>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("loggingOption".equals(element.getName())) {
                String id = element.getAttribute("id");
                String name = element.getAttribute("name");
                if (id != null && id.length() != 0 && name != null && name.length() != 0) {
                    String qId = String.valueOf(element.getContributor().getName()) + "/" + id;
                    options.add(new Option(qId, name));
                }
            }
            ++n2;
        }
        return options;
    }

    private boolean saveValues() {
        Object input = this.viewer.getInput();
        HashMap<String, Boolean> state = new HashMap<String, Boolean>();
        if (input instanceof List) {
            for (Object item : (List)input) {
                if (!(item instanceof Option)) continue;
                state.put(((Option)item).id, Boolean.FALSE);
            }
        }
        HashSet<String> enabled = new HashSet<String>();
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checked = objectArray[n2];
            if (checked instanceof Option) {
                Option option = (Option)checked;
                state.put(option.id, Boolean.TRUE);
                enabled.add(option.id);
            }
            ++n2;
        }
        DLTKLogging.setState(state);
        return true;
    }

    public boolean performOk() {
        return this.saveValues() && super.performOk();
    }

    protected void performApply() {
        if (this.saveValues()) {
            super.performApply();
        }
    }

    public void init(IWorkbench workbench) {
    }

    private static class Option {
        final String id;
        final String name;

        public Option(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    private static class OptionContentProvider
    implements IStructuredContentProvider {
        private OptionContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    private static class OptionLableProvider
    extends LabelProvider {
        private OptionLableProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Option) {
                return ((Option)element).name;
            }
            return super.getText(element);
        }
    }
}

